/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class UrlUtils {
    private UrlUtils() {
    }

    public static boolean isRelative(String url) {
        return url != null && !url.startsWith("/") && !url.matches("^\\w+\\:\\/\\/.*") && !url.startsWith("#");
    }

    public static String rewriteToContextRelative(String url, RequestCycle requestCycle) {
        if (UrlUtils.isRelative(url)) {
            return requestCycle.getUrlRenderer().renderContextRelativeUrl(url);
        }
        return url;
    }

    public static String normalizePath(String path) {
        if (Strings.isEmpty((CharSequence)path)) {
            return "";
        }
        if (!(path = path.trim()).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

