/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoMapper
implements IRequestMapper {
    private static final Logger log = LoggerFactory.getLogger(CryptoMapper.class);
    private final IRequestMapper wrappedMapper;
    private final IProvider<ICrypt> cryptProvider;

    public CryptoMapper(IRequestMapper wrappedMapper, Application application) {
        this(wrappedMapper, new ApplicationCryptProvider(application));
    }

    public CryptoMapper(IRequestMapper wrappedMapper, IProvider<ICrypt> cryptProvider) {
        this.wrappedMapper = (IRequestMapper)Args.notNull((Object)wrappedMapper, (String)"wrappedMapper");
        this.cryptProvider = (IProvider)Args.notNull(cryptProvider, (String)"cryptProvider");
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.wrappedMapper.mapHandler(requestHandler);
        if (url == null) {
            return null;
        }
        return this.encryptUrl(url);
    }

    public IRequestHandler mapRequest(Request request) {
        Url url = this.decryptUrl(request, request.getUrl());
        if (url == null) {
            return null;
        }
        return this.wrappedMapper.mapRequest(request.cloneWithUrl(url));
    }

    protected final ICrypt getCrypt() {
        return (ICrypt)this.cryptProvider.get();
    }

    protected final IRequestMapper getWrappedMapper() {
        return this.wrappedMapper;
    }

    private Url encryptUrl(Url url) {
        if (url.getSegments().isEmpty() && url.getQueryParameters().isEmpty()) {
            return url;
        }
        String encryptedUrlString = this.getCrypt().encryptUrlSafe(url.toString());
        Url encryptedUrl = new Url(url.getCharset());
        encryptedUrl.getSegments().add(encryptedUrlString);
        int numberOfSegments = url.getSegments().size();
        HashedSegmentGenerator generator = new HashedSegmentGenerator(encryptedUrlString);
        for (int segNo = 0; segNo < numberOfSegments; ++segNo) {
            encryptedUrl.getSegments().add(generator.next());
        }
        return encryptedUrl;
    }

    private Url decryptUrl(Request request, Url encryptedUrl) {
        if (encryptedUrl.getSegments().isEmpty()) {
            return encryptedUrl;
        }
        List encryptedSegments = encryptedUrl.getSegments();
        if (encryptedSegments.size() < 1) {
            return null;
        }
        Url url = new Url(request.getCharset());
        try {
            String encryptedSegment;
            String next;
            int segNo;
            String encryptedUrlString = (String)encryptedSegments.get(0);
            if (Strings.isEmpty((CharSequence)encryptedUrlString)) {
                return null;
            }
            String decryptedUrl = this.getCrypt().decryptUrlSafe(encryptedUrlString);
            if (decryptedUrl == null) {
                return null;
            }
            Url originalUrl = Url.parse((CharSequence)decryptedUrl, (Charset)request.getCharset());
            int originalNumberOfSegments = originalUrl.getSegments().size();
            int encryptedNumberOfSegments = encryptedUrl.getSegments().size();
            HashedSegmentGenerator generator = new HashedSegmentGenerator(encryptedUrlString);
            for (segNo = 1; segNo < encryptedNumberOfSegments && segNo <= originalNumberOfSegments && (next = generator.next()).equals(encryptedSegment = (String)encryptedSegments.get(segNo)); ++segNo) {
                url.getSegments().add(originalUrl.getSegments().get(segNo - 1));
            }
            while (segNo < encryptedNumberOfSegments) {
                url.getSegments().add(encryptedUrl.getSegments().get(segNo));
                ++segNo;
            }
            url.getQueryParameters().addAll(originalUrl.getQueryParameters());
        }
        catch (Exception e) {
            log.error("Error decrypting URL", (Throwable)e);
            url = null;
        }
        return url;
    }

    private static class HashedSegmentGenerator {
        private char[] characters;
        private int hash = 0;

        public HashedSegmentGenerator(String string) {
            this.characters = string.toCharArray();
        }

        public String next() {
            char a = this.characters[Math.abs(this.hash % this.characters.length)];
            ++this.hash;
            char b = this.characters[Math.abs(this.hash % this.characters.length)];
            ++this.hash;
            char c = this.characters[Math.abs(this.hash % this.characters.length)];
            String segment = "" + a + b + c;
            this.hash = this.hashString(segment);
            segment = segment + String.format("%02x", Math.abs(this.hash % 256));
            this.hash = this.hashString(segment);
            return segment;
        }

        private int hashString(String str) {
            int hash = 97;
            char[] arr$ = str.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char c;
                char i = c = arr$[i$];
                hash = 47 * hash + i;
            }
            return hash;
        }
    }

    private static class ApplicationCryptProvider
    implements IProvider<ICrypt> {
        private final Application application;

        public ApplicationCryptProvider(Application application) {
            this.application = application;
        }

        public ICrypt get() {
            return this.application.getSecuritySettings().getCryptFactory().newCrypt();
        }
    }
}

