/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractAjaxResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XmlAjaxResponse
extends AbstractAjaxResponse {
    private static final Logger LOG = LoggerFactory.getLogger(XmlAjaxResponse.class);

    XmlAjaxResponse(Page page) {
        super(page);
    }

    @Override
    public void setContentType(WebResponse response, String encoding) {
        response.setContentType("text/xml; charset=" + encoding);
    }

    @Override
    protected void writeHeader(Response response, String encoding) {
        response.write((CharSequence)"<?xml version=\"1.0\" encoding=\"");
        response.write((CharSequence)encoding);
        response.write((CharSequence)"\"?>");
        response.write((CharSequence)"<ajax-response>");
    }

    @Override
    protected void writeComponent(Response response, String markupId, Component component, String encoding) {
        if (component.getRenderBodyOnly()) {
            throw new IllegalStateException("Ajax render cannot be called on component that has setRenderBodyOnly enabled. Component: " + component.toString());
        }
        component.setOutputMarkupId(true);
        this.encodingBodyResponse.reset();
        RequestCycle.get().setResponse(this.encodingBodyResponse);
        Page page = component.findParent(Page.class);
        if (page == null) {
            LOG.debug("component: " + component + " with markupid: " + markupId + " not rendered because it was already removed from page");
            return;
        }
        page.startComponentRender(component);
        try {
            component.prepareForRender();
            this.writeHeaderContribution(response, component);
        }
        catch (RuntimeException e) {
            try {
                component.afterRender();
            }
            catch (RuntimeException e2) {
                // empty catch block
            }
            RequestCycle.get().setResponse(response);
            this.encodingBodyResponse.reset();
            throw e;
        }
        try {
            component.render();
        }
        catch (RuntimeException e) {
            RequestCycle.get().setResponse(response);
            this.encodingBodyResponse.reset();
            throw e;
        }
        page.endComponentRender(component);
        RequestCycle.get().setResponse(response);
        response.write((CharSequence)"<component id=\"");
        response.write((CharSequence)markupId);
        response.write((CharSequence)"\" ");
        if (this.encodingBodyResponse.isContentsEncoded()) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\" ");
        }
        response.write((CharSequence)"><![CDATA[");
        response.write(this.encodingBodyResponse.getContents());
        response.write((CharSequence)"]]></component>");
        this.encodingBodyResponse.reset();
    }

    @Override
    protected void writeFooter(Response response, String encoding) {
        response.write((CharSequence)"</ajax-response>");
    }

    @Override
    protected void writeHeaderContribution(Response response) {
        if (this.encodingHeaderResponse.getContents().length() != 0) {
            response.write((CharSequence)"<header-contribution");
            if (this.encodingHeaderResponse.isContentsEncoded()) {
                response.write((CharSequence)" encoding=\"");
                response.write((CharSequence)this.getEncodingName());
                response.write((CharSequence)"\" ");
            }
            response.write((CharSequence)"><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encodingHeaderResponse.getContents());
            response.write((CharSequence)"</head>]]>");
            response.write((CharSequence)"</header-contribution>");
        }
    }

    @Override
    protected void writeNormalEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "evaluate", scripts);
    }

    @Override
    protected void writePriorityEvaluations(Response response, Collection<CharSequence> scripts) {
        this.writeEvaluations(response, "priority-evaluate", scripts);
    }

    private void writeEvaluations(Response response, String elementName, Collection<CharSequence> scripts) {
        for (CharSequence script : scripts) {
            this.writeEvaluation(elementName, response, script);
        }
    }

    private void writeEvaluation(String invocation, Response response, CharSequence js) {
        boolean encoded = false;
        CharSequence javascript = js;
        if (XmlAjaxResponse.needsEncoding(js)) {
            encoded = true;
            javascript = XmlAjaxResponse.encode(js);
        }
        response.write((CharSequence)"<");
        response.write((CharSequence)invocation);
        if (encoded) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\"");
        }
        response.write((CharSequence)">");
        response.write((CharSequence)"<![CDATA[");
        response.write(javascript);
        response.write((CharSequence)"]]>");
        response.write((CharSequence)"</");
        response.write((CharSequence)invocation);
        response.write((CharSequence)">");
        this.encodingBodyResponse.reset();
    }
}

