/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.common.run;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.loader.WebappLoader;
import org.apache.maven.plugin.logging.Log;

public class ExternalRepositoriesReloadableWebappLoader
extends WebappLoader {
    private Map<String, Long> modificationTimeMap = new HashMap<String, Long>();
    private Log log;

    public ExternalRepositoriesReloadableWebappLoader() {
    }

    public ExternalRepositoriesReloadableWebappLoader(ClassLoader parent, Log log) {
        super(parent);
        this.log = log;
    }

    public void addRepository(String repository) {
        super.addRepository(repository);
        try {
            File file = new File(new URL(repository).getPath().replaceAll("%20", " "));
            if (file.isDirectory()) {
                this.addClassDirectory(file);
            } else if (file.isFile() && file.getName().endsWith(".jar")) {
                this.addFile(file);
            }
        }
        catch (MalformedURLException muex) {
            throw new RuntimeException(muex);
        }
    }

    private void addClassDirectory(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.addFile(file);
                this.addClassDirectory(file);
                continue;
            }
            if (!file.isFile()) continue;
            this.addFile(file);
        }
    }

    private void addFile(File file) {
        this.modificationTimeMap.put(file.getAbsolutePath(), file.lastModified());
    }

    public boolean modified() {
        boolean modified = super.modified();
        if (!modified) {
            if (this.log != null) {
                this.log.debug((CharSequence)("classPath scanning started at " + new Date().toString()));
            }
            for (Map.Entry<String, Long> entry : this.modificationTimeMap.entrySet()) {
                String key = entry.getKey();
                File file = new File(key);
                if (!file.exists()) continue;
                Long savedLastModified = this.modificationTimeMap.get(key);
                if (file.lastModified() <= savedLastModified) continue;
                modified = true;
                this.modificationTimeMap.put(key, file.lastModified());
                if (!file.isDirectory()) continue;
                this.addClassDirectory(file);
            }
        }
        if (this.log != null) {
            this.log.debug((CharSequence)("context " + modified + " at " + new Date().toString()));
        }
        return modified;
    }
}

