/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.openxml4j.document.OpenXMLDocument;
import org.openxml4j.document.wordprocessing.Paragraph;
import org.openxml4j.document.wordprocessing.Picture;
import org.openxml4j.document.wordprocessing.model.table.TableDescription;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.StreamHelper;
import org.openxml4j.opc.internal.PartMarshaller;
import org.openxml4j.opc.internal.marshallers.ZipPartMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WordDocument
extends OpenXMLDocument {
    static final String PATH_WORD_DOCUMENT_XML = "word/document.xml";
    public static final Namespace namespaceWord = new Namespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
    private Document content;
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    private MainDocumentHelper mainDocumentHelper = new MainDocumentHelper();

    public WordDocument(Package pack) throws OpenXML4JException {
        super(pack);
        if (!this.mainDocumentHelper.parseDocumentContent()) {
            throw new OpenXML4JException("error in parsing doc");
        }
        this.container.addMarshaller("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", this.mainDocumentHelper);
    }

    public PackagePart getCorePart() throws OpenXML4JException {
        return this.container.getPartsByRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").get(0);
    }

    public Document getCoreDocument() {
        return this.content;
    }

    public void setStyleForParagraphs() {
        List paragraphNodeList = this.content.getRootElement().elements(new QName("p", namespaceWord));
        for (Element element : paragraphNodeList) {
            if (Paragraph.hasStyleName(element) != null) continue;
            Paragraph.addDefaultStyleXmlCode(element);
            logger.debug((Object)"adding default parameter style");
        }
    }

    protected Element getDocumentBody() {
        return this.content.getRootElement().element(new QName("body", namespaceWord));
    }

    protected PackageRelationshipCollection getCollectionOfImageRelationshipsToForwardToNextDocument() throws OpenXML4JException {
        PackageRelationshipCollection listOfImages = null;
        try {
            PackagePart docPart = this.container.getPart(PackagingURIHelper.createPartName(new URI(PATH_WORD_DOCUMENT_XML)));
            if (docPart.hasRelationships()) {
                PackageRelationshipCollection relList = docPart.getRelationships();
                listOfImages = relList.getRelationships("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            }
        }
        catch (URISyntaxException e) {
            logger.error((Object)"cannot generate URI", (Throwable)e);
        }
        return listOfImages;
    }

    private boolean isNodeParagraph(Element curNode) {
        return curNode.getName().equals("p");
    }

    private boolean isNodeTable(Node curNode) {
        return curNode.getName().equals("tbl");
    }

    private boolean isNodeIndentText(Node curNode) {
        String strToTest = curNode.getName();
        return strToTest.equals("#text");
    }

    private List<Element> getListOfNodeToInsert(Element textToAppend, TreeMap<String, String> mapOldIdToNewId) {
        ArrayList<Element> listOfNodes = new ArrayList<Element>();
        Iterator j = textToAppend.elementIterator();
        while (j.hasNext()) {
            Element curNodeToInsert = (Element)j.next();
            if (this.isNodeParagraphOrTable(curNodeToInsert)) {
                Element copyNode = (Element)curNodeToInsert.clone();
                ArrayList<Element> listOfImages = new ArrayList<Element>();
                Picture.getListReferenceForImages(copyNode, listOfImages);
                if (!listOfImages.isEmpty() && !Picture.addNewReferences(listOfImages, mapOldIdToNewId)) {
                    return null;
                }
                listOfNodes.add(copyNode);
                continue;
            }
            logger.debug((Object)("node ignored for paragraph insertion:" + curNodeToInsert.getName() + " " + curNodeToInsert.getStringValue()));
        }
        return listOfNodes;
    }

    private boolean isNodeParagraphOrTable(Element curNodeToInsert) {
        if (this.isNodeParagraph(curNodeToInsert)) {
            return true;
        }
        return this.isNodeTable((Node)curNodeToInsert);
    }

    public boolean appendAllParagraph(Element paragraphToAppend, TreeMap<String, String> mapOldIdToNewId) {
        List<Element> listParagraphToInsert = this.getListOfNodeToInsert(paragraphToAppend, mapOldIdToNewId);
        if (listParagraphToInsert == null) {
            return false;
        }
        Element body = this.getDocumentBody();
        Iterator i = body.elementIterator();
        while (i.hasNext()) {
            Element curNode = (Element)i.next();
            if (this.isNodeParagraphOrTable(curNode) || this.isNodeIndentText((Node)curNode)) continue;
            for (Node node : listParagraphToInsert) {
                body.elements().add(body.elements().indexOf(curNode), node);
            }
            return true;
        }
        Iterator<Element> iter = listParagraphToInsert.iterator();
        while (iter.hasNext()) {
            logger.debug((Object)"appending to body");
            Node curNodeToInsert = (Node)iter.next();
            body.elements().add(curNodeToInsert);
        }
        return true;
    }

    public void appendParagraph(Paragraph paragraph) {
        Element body = this.getDocumentBody();
        Iterator i = body.elementIterator();
        while (i.hasNext()) {
            Element curNode = (Element)i.next();
            if (this.isNodeParagraphOrTable(curNode) || this.isNodeIndentText((Node)curNode)) continue;
            body.elements().add(body.elements().indexOf(curNode), paragraph.build());
            return;
        }
        body.add(paragraph.build());
    }

    public void appendTable(TableDescription table) throws OpenXML4JException {
        Element body = this.getDocumentBody();
        Iterator i = body.elementIterator();
        while (i.hasNext()) {
            Element curNode = (Element)i.next();
            if (this.isNodeParagraphOrTable(curNode) || this.isNodeIndentText((Node)curNode)) continue;
            body.elements().add(body.elements().indexOf(curNode), table.build());
            return;
        }
        body.add(table.build());
    }

    private boolean checkElementIsPermStart(Element element) {
        return element.getName().equals("permStart");
    }

    private boolean isWriteEnabledItem(Element nodeToCheck) throws OpenXML4JException {
        Iterator i = nodeToCheck.elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            List listOfChild = element.elements();
            if (listOfChild.size() == 0) {
                return this.checkElementIsPermStart(element);
            }
            if (this.checkElementIsPermStart(element)) {
                return true;
            }
            for (Element child : listOfChild) {
                if (this.checkElementIsPermStart(child)) {
                    return true;
                }
                this.checkElementIsPermStart(child);
            }
        }
        return false;
    }

    private boolean checkAndRemoveAllWriteEnableTags(Element element) {
        if (element.getName().equals("permStart")) {
            element.getParent().remove(element);
            return true;
        }
        if (element.getName().equals("permEnd")) {
            element.getParent().remove(element);
            return true;
        }
        return false;
    }

    private void removeAllWriteEnabledTags(Element element) {
        List listOfChild = element.elements();
        if (listOfChild.size() == 0) {
            this.checkAndRemoveAllWriteEnableTags(element);
        } else {
            if (this.checkAndRemoveAllWriteEnableTags(element)) {
                return;
            }
            for (Element child : listOfChild) {
                this.checkAndRemoveAllWriteEnableTags(child);
            }
        }
    }

    public void removeWriteEnabledTags() throws OpenXML4JException {
        Iterator i = this.getDocumentBody().elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            this.removeAllWriteEnabledTags(element);
        }
    }

    @Override
    public void save(File file) {
        throw new InvalidOperationException("Method not implemented !");
    }

    public void stripReadOnlyPartOfDocument() throws OpenXML4JException {
        List paragraphNodeList = this.getDocumentBody().elements(new QName("p", namespaceWord));
        for (Element element : paragraphNodeList) {
            if (this.isWriteEnabledItem(element)) continue;
            Element father = element.getParent();
            father.remove(element);
        }
    }

    class MainDocumentHelper
    implements PartMarshaller {
        MainDocumentHelper() {
        }

        private boolean parseDocumentContent() throws OpenXML4JException {
            PackagePart contentPart = WordDocument.this.getCorePart();
            if (contentPart == null) {
                logger.error((Object)"The document has no contents!");
                return false;
            }
            logger.debug((Object)("reading doc content:" + contentPart.getPartName()));
            InputStream inStream = null;
            try {
                inStream = contentPart.getInputStream();
            }
            catch (IOException e) {
                logger.error((Object)"error reading the document.xml", (Throwable)e);
                return false;
            }
            try {
                SAXReader reader = new SAXReader();
                WordDocument.this.content = reader.read(inStream);
            }
            catch (DocumentException e) {
                logger.error((Object)"cannot read input", (Throwable)e);
                return false;
            }
            return true;
        }

        public boolean marshall(PackagePart part, OutputStream os) throws OpenXML4JException {
            if (!(os instanceof ZipOutputStream)) {
                logger.error((Object)("ZipOutputSTream expected!" + os.getClass().getName()));
                throw new OpenXML4JException("ZipOutputSTream expected!");
            }
            ZipOutputStream out = (ZipOutputStream)os;
            ZipEntry ctEntry = new ZipEntry(part.getPartName().getURI().getPath());
            try {
                out.putNextEntry(ctEntry);
                if (!StreamHelper.saveXmlInStream(WordDocument.this.content, out)) {
                    return false;
                }
                logger.debug((Object)"recording word doc relationship");
                if (part.hasRelationships()) {
                    ZipPartMarshaller.marshallRelationshipPart(part.getRelationships(), PackagingURIHelper.getRelationshipPartName(part.getPartName()), out);
                }
                out.closeEntry();
            }
            catch (IOException e1) {
                logger.error((Object)("IO problem with " + part.getPartName()), (Throwable)e1);
                return false;
            }
            return true;
        }
    }
}

