/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class IndexEntry {
    private final IndexEntry parent;
    private String id;
    private String title;
    private List childEntries = new ArrayList();
    private static final String EOL = System.getProperty("line.separator");

    public IndexEntry(String newId) {
        this(null, newId);
    }

    public IndexEntry(IndexEntry newParent, String newId) {
        this.parent = newParent;
        this.id = newId;
        if (this.parent != null) {
            this.parent.childEntries.add(this);
        }
    }

    public IndexEntry getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public List getChildEntries() {
        return Collections.unmodifiableList(this.childEntries);
    }

    public void setChildEntries(List entries) {
        if (entries == null) {
            this.childEntries = new ArrayList();
        }
        this.childEntries = entries;
    }

    public IndexEntry getNextEntry() {
        if (this.parent == null) {
            return null;
        }
        List entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index + 1 >= entries.size()) {
            return null;
        }
        return (IndexEntry)entries.get(index + 1);
    }

    public IndexEntry getPrevEntry() {
        if (this.parent == null) {
            return null;
        }
        List entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index == 0) {
            return null;
        }
        return (IndexEntry)entries.get(index - 1);
    }

    public IndexEntry getFirstEntry() {
        List entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return (IndexEntry)entries.get(0);
    }

    public IndexEntry getLastEntry() {
        List entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return (IndexEntry)entries.get(entries.size() - 1);
    }

    public IndexEntry getRootEntry() {
        List entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            throw new RuntimeException("This index has more than one root entry");
        }
        return (IndexEntry)entries.get(0);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        StringBuffer message = new StringBuffer();
        message.append("Id: ").append(this.id);
        if (StringUtils.isNotEmpty((String)this.title)) {
            message.append(", title: ").append(this.title);
        }
        message.append(EOL);
        String indent = "";
        for (int i = 0; i < depth; ++i) {
            indent = indent + " ";
        }
        Iterator it = this.getChildEntries().iterator();
        while (it.hasNext()) {
            IndexEntry entry = (IndexEntry)it.next();
            message.append(indent).append(entry.toString(depth + 1));
        }
        return message.toString();
    }
}

