/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RNTO
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RNTO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            String toFileStr = request.getArgument();
            if (toFileStr == null) {
                session.write(LocalizedFtpReply.translate(session, request, context, 501, "RNTO", null));
                return;
            }
            FtpFile frFile = session.getRenameFrom();
            if (frFile == null) {
                session.write(LocalizedFtpReply.translate(session, request, context, 503, "RNTO", null));
                return;
            }
            FtpFile toFile = null;
            try {
                toFile = session.getFileSystemView().getFile(toFileStr);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting file object", (Throwable)ex);
            }
            if (toFile == null) {
                session.write(LocalizedFtpReply.translate(session, request, context, 553, "RNTO.invalid", null));
                return;
            }
            toFileStr = toFile.getAbsolutePath();
            if (!toFile.isWritable()) {
                session.write(LocalizedFtpReply.translate(session, request, context, 553, "RNTO.permission", null));
                return;
            }
            if (!frFile.doesExist()) {
                session.write(LocalizedFtpReply.translate(session, request, context, 553, "RNTO.missing", null));
                return;
            }
            String logFrFileAbsolutePath = frFile.getAbsolutePath();
            if (frFile.move(toFile)) {
                session.write(LocalizedFtpReply.translate(session, request, context, 250, "RNTO", toFileStr));
                this.LOG.info("File rename from \"{}\" to \"{}\"", (Object)logFrFileAbsolutePath, (Object)toFile.getAbsolutePath());
            } else {
                session.write(LocalizedFtpReply.translate(session, request, context, 553, "RNTO", toFileStr));
            }
        }
        finally {
            session.resetState();
        }
    }
}

