/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import java.io.Serializable;
import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.ComparatorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableComparator<E>
implements Comparator<E>,
Serializable {
    private static final long serialVersionUID = 3257566226288162870L;
    private static ComparatorRegistry registry;
    private String matchingRuleOid;
    private transient Comparator<E> wrapped;

    public static void setRegistry(ComparatorRegistry registry) {
        SerializableComparator.registry = registry;
    }

    public SerializableComparator(String matchingRuleOid) {
        this.matchingRuleOid = matchingRuleOid;
    }

    @Override
    public int compare(E o1, E o2) {
        if (this.wrapped == null) {
            try {
                this.wrapped = registry.lookup(this.matchingRuleOid);
            }
            catch (NamingException e) {
                throw new RuntimeException("Matching rule not found: " + this.matchingRuleOid);
            }
        }
        return this.wrapped.compare(o1, o2);
    }
}

