
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the mozilla schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class MozillaAttributeTypeProducer extends AbstractBootstrapProducer
{

    public MozillaAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.1", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "xmozillanickname" );
        names.add( "mozillaNickname" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.2", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.7" );

        names.clear();
        names.add( "xmozillausehtmlmail" );
        names.add( "mozillaUseHtmlMail" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.3", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "mozillaSecondEmail" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.4", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "mozillaHomeLocalityName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.5", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreListMatch" );
        attributeType.setSubstrId( "caseIgnoreListSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.41" );

        names.clear();
        names.add( "mozillaPostalAddress2" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.6", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreListMatch" );
        attributeType.setSubstrId( "caseIgnoreListSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.41" );

        names.clear();
        names.add( "mozillaHomePostalAddress2" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.7", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "mozillaHomeState" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.8", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 40 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "mozillaHomePostalCode" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.9", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "mozillaHomeCountryName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.10", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "mozillaHomeFriendlyCountryName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.11", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "homeurl" );
        names.add( "mozillaHomeUrl" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.12", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "workurl" );
        names.add( "mozillaWorkUrl" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.13", registries );
        attributeType.setDescription( "AOL Instant Messenger (AIM) Identity" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "telephoneNumberMatch" );
        attributeType.setSubstrId( "telephoneNumberSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.50" );

        names.clear();
        names.add( "nsAIMid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.96 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.96", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "custom1" );
        names.add( "mozillaCustom1" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.96", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.97 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.97", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "custom2" );
        names.add( "mozillaCustom2" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.97", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.98 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.98", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "custom3" );
        names.add( "mozillaCustom3" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.98", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.13769.2.1.99 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.13769.2.1.99", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "custom4" );
        names.add( "mozillaCustom4" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.1.99", attributeType );
    }
}
