
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the krb5kdc schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class Krb5kdcAttributeTypeProducer extends AbstractBootstrapProducer
{

    public Krb5kdcAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.1", registries );
        attributeType.setDescription( "The unparsed Kerberos principal name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "krb5PrincipalName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.2", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "krb5KeyVersionNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.3", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "krb5MaxLife" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.4", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "krb5MaxRenew" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.5", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "krb5KDCFlags" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.6", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "krb5EncryptionType" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.7", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setOrderingId( "generalizedTimeOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "krb5ValidStart" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.8", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setOrderingId( "generalizedTimeOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "krb5ValidEnd" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.9", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setOrderingId( "generalizedTimeOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "krb5PasswordEnd" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.10", registries );
        attributeType.setDescription( "Encoded ASN1 Key as an octet string" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.5" );

        names.clear();
        names.add( "krb5Key" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.11", registries );
        attributeType.setDescription( "Distinguished name of krb5Realm entry" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "distinguishedName" );

        names.clear();
        names.add( "krb5PrincipalRealm" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.12", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "krb5RealmName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.13", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "booleanMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.7" );

        names.clear();
        names.add( "krb5AccountDisabled" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.14", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "booleanMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.7" );

        names.clear();
        names.add( "krb5AccountLockedOut" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.5322.10.1.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.5322.10.1.15", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "krb5AccountExpirationTime" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.1.15", attributeType );
    }
}
