/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTupleArrayCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private final ArrayTreeCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleArrayCursor(ArrayTree<V> arrayTree, K key) {
        this.key = key;
        this.wrapped = new ArrayTreeCursor(arrayTree);
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
        }
        this.wrapped.before(value);
        this.clearValue();
    }

    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
        }
        this.wrapped.after(value);
        this.clearValue();
    }

    public void before(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("before()");
        this.wrapped.before(element.getValue());
        this.clearValue();
    }

    public void after(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("after()");
        this.wrapped.after(element.getValue());
        this.clearValue();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.clearValue();
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clearValue();
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.wrapped.previous()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.wrapped.next()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public boolean isElementReused() {
        return true;
    }
}

