/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import javax.naming.Binding;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerAdapter
implements DirectoryListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerAdapter.class);
    private final NamingListener listener;
    private final ServerLdapContext source;
    private final SearchControls controls;

    public EventListenerAdapter(ServerLdapContext source, NamingListener listener) {
        this(source, listener, new SearchControls());
    }

    public EventListenerAdapter(ServerLdapContext source, NamingListener listener, SearchControls controls) {
        this.source = source;
        this.controls = controls;
        this.listener = listener;
    }

    private void deliverNamingExceptionEvent(Exception e, OperationContext opContext) {
        LOG.error("Error encountered while delivering notifications.", (Throwable)e);
        NamingExceptionEvent evt = null;
        if (e instanceof NamingException) {
            evt = new NamingExceptionEvent(this.source, (NamingException)e);
        } else {
            NamingException ne = new NamingException("Encountered exception during event handling.");
            ne.setRootCause(e);
            evt = new NamingExceptionEvent(this.source, ne);
        }
        this.listener.namingExceptionThrown(evt);
    }

    public void entryAdded(AddOperationContext opContext) {
        try {
            Binding binding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
            NamingEvent evt = new NamingEvent(this.source, 0, binding, null, opContext);
            if (this.listener instanceof NamespaceChangeListener) {
                ((NamespaceChangeListener)this.listener).objectAdded(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }

    public void entryDeleted(DeleteOperationContext opContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding binding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 1, null, binding, opContext);
                ((NamespaceChangeListener)this.listener).objectAdded(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }

    public void entryModified(ModifyOperationContext opContext) {
        try {
            Binding newBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
            Binding oldBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry().getOriginalEntry()), false);
            NamingEvent evt = new NamingEvent(this.source, 3, newBinding, oldBinding, opContext);
            if (this.listener instanceof ObjectChangeListener) {
                ((ObjectChangeListener)this.listener).objectChanged(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }

    public void entryMoved(MoveOperationContext opContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
                Binding oldBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry().getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, opContext);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }

    public void entryMovedAndRenamed(MoveAndRenameOperationContext opContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
                Binding oldBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry().getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, opContext);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }

    public void entryRenamed(RenameOperationContext opContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry()), false);
                Binding oldBinding = new Binding(opContext.getDn().getUpName(), ServerEntryUtils.toBasicAttributes((ServerEntry)opContext.getEntry().getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, null);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e, (OperationContext)opContext);
        }
    }
}

