/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.shared.ldap.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTreeCursor<K>
extends AbstractCursor<K> {
    private ArrayTree<K> array;
    private K node;
    private boolean onNode = false;
    private boolean isAfterLast = false;
    private boolean isBeforeFirst = true;
    private int current;

    public ArrayTreeCursor(ArrayTree<K> array) {
        this.array = array;
        this.current = -1;
    }

    public void after(K element) throws Exception {
        this.checkNotClosed("after");
        if (element == null) {
            this.afterLast();
            return;
        }
        int found = this.array.getAfterPosition(element);
        if (found == -1) {
            this.afterLast();
            return;
        }
        this.current = found;
        this.isAfterLast = false;
        this.isBeforeFirst = false;
        this.onNode = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.current = this.array.size() - 1;
        this.node = this.array.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = true;
        this.onNode = false;
    }

    public boolean available() {
        return this.onNode;
    }

    public void before(K element) throws Exception {
        this.checkNotClosed("before");
        if (element == null) {
            this.beforeFirst();
            return;
        }
        int found = this.array.getBeforePosition(element);
        if (found < 0) {
            this.beforeFirst();
            return;
        }
        this.current = found;
        this.isAfterLast = false;
        this.isBeforeFirst = false;
        this.onNode = true;
        this.node = this.array.get(this.current);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.current = 0;
        this.node = this.array.getFirst();
        this.isBeforeFirst = true;
        this.isAfterLast = false;
        this.onNode = false;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.current = 0;
        this.node = this.array.getFirst();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    public K get() throws Exception {
        this.checkNotClosed("get");
        if (this.onNode) {
            return this.node;
        }
        throw new InvalidCursorPositionException();
    }

    public boolean isElementReused() {
        return true;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.current = this.array.size() - 1;
        this.node = this.array.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next");
        if (this.array.size() == 0) {
            return false;
        }
        if (this.isBeforeFirst) {
            this.current = 0;
            this.node = this.array.getFirst();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.isAfterLast) {
            return false;
        }
        if (this.onNode) {
            ++this.current;
            if (this.current == this.array.size()) {
                this.afterLast();
                return false;
            }
        }
        this.node = this.array.get(this.current);
        this.onNode = this.node != null;
        return this.onNode;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        if (this.array.size() == 0) {
            return false;
        }
        if (this.isBeforeFirst) {
            return false;
        }
        if (this.isAfterLast) {
            this.current = this.array.size() - 1;
            this.node = this.array.getLast();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.onNode) {
            --this.current;
            if (this.current < 0) {
                this.beforeFirst();
                return false;
            }
        }
        this.node = this.array.get(this.current);
        this.onNode = this.node != null;
        return this.onNode;
    }
}

