/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifRevertor;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeLogInterceptor.class);
    private AttributeType entryDeleted;
    private ChangeLog changeLog;
    private SchemaService schemaService;
    private static final String REV_AT_OID = "1.3.6.1.4.1.18060.0.4.1.2.47";

    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.changeLog = directoryService.getChangeLog();
        this.schemaService = directoryService.getSchemaService();
        this.entryDeleted = directoryService.getSchemaManager().lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.31");
    }

    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        next.add(opContext);
        if (!this.changeLog.isEnabled() || !opContext.isFirstOperation()) {
            return;
        }
        ClonedServerEntry addEntry = opContext.getEntry();
        if (addEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Add);
        forward.setDn(opContext.getDn());
        Set list = addEntry.getAttributeTypes();
        for (AttributeType attributeType : list) {
            forward.addAttribute(addEntry.get(attributeType).toClientAttribute());
        }
        LdifEntry reverse = LdifRevertor.reverseAdd((DN)opContext.getDn());
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        ServerEntry serverEntry = null;
        if (this.changeLog.isEnabled() && opContext.isFirstOperation()) {
            serverEntry = this.getAttributes((OperationContext)opContext);
        }
        next.delete(opContext);
        if (!this.changeLog.isEnabled() || !opContext.isFirstOperation()) {
            return;
        }
        if (serverEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Delete);
        forward.setDn(opContext.getDn());
        DefaultClientEntry reverseEntry = new DefaultClientEntry(serverEntry.getDn());
        for (EntryAttribute attribute : serverEntry) {
            AttributeType at = (AttributeType)this.schemaService.getSchemaManager().getAttributeTypeRegistry().lookup(attribute.getId());
            if (at.isCollective()) continue;
            reverseEntry.add(new EntryAttribute[]{attribute.toClientAttribute()});
        }
        LdifEntry reverse = LdifRevertor.reverseDel((DN)opContext.getDn(), (Entry)reverseEntry);
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    private ServerEntry getAttributes(OperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (this.schemaService.isSchemaSubentry(dn.getNormName())) {
            return this.schemaService.getSubschemaEntryCloned();
        }
        ClonedServerEntry serverEntry = opContext.lookup(dn, ByPassConstants.LOOKUP_BYPASS);
        return serverEntry;
    }

    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        boolean isDelete;
        ServerEntry serverEntry = null;
        Modification modification = ServerEntryUtils.getModificationItem((List)opContext.getModItems(), (AttributeType)this.entryDeleted);
        boolean bl = isDelete = modification != null;
        if (!isDelete && this.changeLog.isEnabled() && opContext.isFirstOperation()) {
            serverEntry = this.getAttributes((OperationContext)opContext);
        }
        ArrayList<Modification> clonedMods = new ArrayList<Modification>();
        for (Modification mod : opContext.getModItems()) {
            clonedMods.add(mod.clone());
        }
        next.modify(opContext);
        if (isDelete || !this.changeLog.isEnabled() || !opContext.isFirstOperation() || opContext.getModItems().size() == 0) {
            if (isDelete) {
                LOG.debug("Bypassing changelog on modify of entryDeleted attribute.");
            }
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Modify);
        forward.setDn(opContext.getDn());
        ArrayList<Modification> mods = new ArrayList<Modification>(clonedMods.size());
        for (Modification modItem : clonedMods) {
            Modification mod = ((ServerModification)modItem).toClientModification();
            mod.getAttribute().setId(modItem.getAttribute().getId());
            mods.add(mod);
            forward.addModificationItem(mod);
        }
        DefaultClientEntry clientEntry = new DefaultClientEntry(serverEntry.getDn());
        for (EntryAttribute attribute : serverEntry) {
            clientEntry.add(new EntryAttribute[]{attribute.toClientAttribute()});
        }
        LdifEntry reverse = LdifRevertor.reverseModify((DN)opContext.getDn(), mods, (Entry)clientEntry);
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws Exception {
        ServerEntry serverEntry = null;
        if (renameContext.getEntry() != null) {
            serverEntry = renameContext.getEntry().getOriginalEntry();
        }
        next.rename(renameContext);
        if (!this.changeLog.isEnabled() || !renameContext.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModRdn);
        forward.setDn(renameContext.getDn());
        forward.setNewRdn(renameContext.getNewRdn().getName());
        forward.setDeleteOldRdn(renameContext.getDelOldDn());
        List reverses = LdifRevertor.reverseRename((Entry)serverEntry, (RDN)renameContext.getNewRdn(), (boolean)renameContext.getDelOldDn());
        renameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opCtx) throws Exception {
        ClonedServerEntry serverEntry = null;
        if (this.changeLog.isEnabled() && opCtx.isFirstOperation()) {
            serverEntry = opCtx.lookup(opCtx.getDn(), ByPassConstants.LOOKUP_BYPASS);
        }
        next.moveAndRename(opCtx);
        if (!this.changeLog.isEnabled() || !opCtx.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(opCtx.getDn());
        forward.setDeleteOldRdn(opCtx.getDelOldDn());
        forward.setNewRdn(opCtx.getNewRdn().getName());
        forward.setNewSuperior(opCtx.getParent().getName());
        List reverses = LdifRevertor.reverseMoveAndRename((Entry)serverEntry, (DN)opCtx.getParent(), (RDN)new RDN(opCtx.getNewRdn()), (boolean)false);
        opCtx.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void move(NextInterceptor next, MoveOperationContext opCtx) throws Exception {
        next.move(opCtx);
        if (!this.changeLog.isEnabled() || !opCtx.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(opCtx.getDn());
        forward.setNewSuperior(opCtx.getParent().getName());
        LdifEntry reverse = LdifRevertor.reverseMove((DN)opCtx.getParent(), (DN)opCtx.getDn());
        opCtx.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }
}

