/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedUserClassFilter
implements ACITupleFilter {
    private static final DN ROOTDSE_NAME = DN.EMPTY_DN;
    private final SubtreeEvaluator subtreeEvaluator;

    public RelatedUserClassFilter(SubtreeEvaluator subtreeEvaluator) {
        this.subtreeEvaluator = subtreeEvaluator;
    }

    @Override
    public Collection<ACITuple> filter(SchemaManager schemaManager, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<DN> userGroupNames, DN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, DN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws LdapException {
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> ii = tuples.iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (tuple.isGrant()) {
                if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) && authenticationLevel.compareTo((Enum)tuple.getAuthenticationLevel()) >= 0) continue;
                ii.remove();
                continue;
            }
            if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) || authenticationLevel.compareTo((Enum)tuple.getAuthenticationLevel()) < 0) continue;
            ii.remove();
        }
        return tuples;
    }

    private boolean isRelated(Collection<DN> userGroupNames, DN userName, ServerEntry userEntry, DN entryName, Collection<UserClass> userClasses) throws LdapException {
        for (UserClass userClass : userClasses) {
            if (userClass == UserClass.ALL_USERS) {
                return true;
            }
            if (userClass == UserClass.THIS_ENTRY) {
                if (!userName.equals((Object)entryName)) continue;
                return true;
            }
            if (userClass == UserClass.PARENT_OF_ENTRY) {
                if (!entryName.isChildOf(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.Name) {
                UserClass.Name nameUserClass = (UserClass.Name)userClass;
                if (!nameUserClass.getNames().contains(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.UserGroup) {
                UserClass.UserGroup userGroupUserClass = (UserClass.UserGroup)userClass;
                for (DN userGroupName : userGroupNames) {
                    Set dns = userGroupUserClass.getNames();
                    if (userGroupName == null) continue;
                    for (DN dn : dns) {
                        if (!userGroupName.getNormName().equals(dn.getNormName())) continue;
                        return true;
                    }
                }
                continue;
            }
            if (userClass instanceof UserClass.Subtree) {
                UserClass.Subtree subtree = (UserClass.Subtree)userClass;
                if (!this.matchUserClassSubtree(userName, userEntry, subtree)) continue;
                return true;
            }
            throw new InternalError(I18n.err((String)I18n.ERR_233, (Object[])new Object[]{userClass.getClass().getName()}));
        }
        return false;
    }

    private boolean matchUserClassSubtree(DN userName, ServerEntry userEntry, UserClass.Subtree subtree) throws LdapException {
        for (SubtreeSpecification subtreeSpec : subtree.getSubtreeSpecifications()) {
            if (!this.subtreeEvaluator.evaluate(subtreeSpec, ROOTDSE_NAME, userName, userEntry)) continue;
            return true;
        }
        return false;
    }
}

