/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcUtils;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcExecutionManager {
    private static final Set<AttributeTypeOptions> EMPTY_ATTRIBS = Collections.emptySet();
    private final String storedProcContainer;
    private final List<StoredProcEngineConfig> storedProcEngineConfigs;

    public StoredProcExecutionManager(String storedProcContainer, List<StoredProcEngineConfig> storedProcEngineConfigs) {
        this.storedProcContainer = storedProcContainer;
        this.storedProcEngineConfigs = storedProcEngineConfigs;
    }

    public ClonedServerEntry findStoredProcUnit(CoreSession session, String fullSPName) throws Exception {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        controls.setSearchScope(2);
        String spUnitName = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        AttributeType at = session.getDirectoryService().getRegistries().getAttributeTypeRegistry().lookup("storedProcUnitName");
        EqualityNode filter = new EqualityNode("storedProcUnitName", (Value)new ServerStringValue(at, spUnitName));
        LdapDN dn = new LdapDN(this.storedProcContainer);
        EntryFilteringCursor results = session.search(dn, SearchScope.SUBTREE, (ExprNode)filter, AliasDerefMode.DEREF_ALWAYS, EMPTY_ATTRIBS);
        if (results.first()) {
            ClonedServerEntry entry = (ClonedServerEntry)results.get();
            results.close();
            return entry;
        }
        return null;
    }

    public StoredProcEngine getStoredProcEngineInstance(ClonedServerEntry spUnitEntry) throws NamingException {
        String spLangId = spUnitEntry.getOriginalEntry().get("storedProcLangId").getString();
        for (StoredProcEngineConfig engineConfig : this.storedProcEngineConfigs) {
            StoredProcEngine engine;
            if (!engineConfig.getStoredProcLangId().equalsIgnoreCase(spLangId)) continue;
            Class<? extends StoredProcEngine> engineType = engineConfig.getStoredProcEngineType();
            try {
                engine = engineType.newInstance();
            }
            catch (InstantiationException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
            catch (IllegalAccessException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
            engine.setSPUnitEntry(spUnitEntry.getOriginalEntry());
            return engine;
        }
        throw new NamingException("Stored Procedure Language, " + spLangId + " is not supported.");
    }
}

