/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsKeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TlsKeyGenerator.class);
    public static final String TLS_KEY_INFO_OC = "tlsKeyInfo";
    public static final String PRIVATE_KEY_AT = "privateKey";
    public static final String PUBLIC_KEY_AT = "publicKey";
    public static final String KEY_ALGORITHM_AT = "keyAlgorithm";
    public static final String PRIVATE_KEY_FORMAT_AT = "privateKeyFormat";
    public static final String PUBLIC_KEY_FORMAT_AT = "publicKeyFormat";
    public static final String USER_CERTIFICATE_AT = "userCertificate";
    public static final String CERTIFICATE_PRINCIPAL_DN = "CN=ApacheDS, OU=Directory, O=ASF, C=US";
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 512;
    private static final long YEAR_MILLIS = 31536000000L;

    public static X509Certificate getCertificate(ServerEntry entry) throws NamingException {
        X509Certificate cert = null;
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed to get BC Certificate factory for algorithm: X.509");
            ne.setRootCause(e);
            throw ne;
        }
        byte[] certBytes = entry.get(USER_CERTIFICATE_AT).getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
        try {
            cert = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            NamingException ne = new NamingException("Bad certificate format.");
            ne.setRootCause(e);
            throw ne;
        }
        return cert;
    }

    public static KeyPair getKeyPair(ServerEntry entry) throws NamingException {
        PublicKey publicKey = null;
        PrivateKey privateKey = null;
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(ALGORITHM);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed to get key factory for algorithm: RSA");
            ne.setRootCause(e);
            throw ne;
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(entry.get(PRIVATE_KEY_AT).getBytes());
        try {
            privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Bad private key format.");
            ne.setRootCause(e);
            throw ne;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(entry.get(PUBLIC_KEY_AT).getBytes());
        try {
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            NamingException ne = new NamingException("Bad public key format.");
            ne.setRootCause(e);
            throw ne;
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static void addKeyPair(ServerEntry entry) throws NamingException {
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            entry.put("objectClass", new String[]{TLS_KEY_INFO_OC, "inetOrgPerson"});
        } else {
            objectClass.add(new String[]{TLS_KEY_INFO_OC, "inetOrgPerson"});
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            NamingException ne = new NamingException("Cannot generate key pair for TLS");
            ne.setRootCause(e);
            throw ne;
        }
        generator.initialize(512);
        KeyPair keypair = generator.genKeyPair();
        entry.put(KEY_ALGORITHM_AT, new String[]{ALGORITHM});
        PrivateKey privateKey = keypair.getPrivate();
        entry.put(PRIVATE_KEY_AT, (byte[][])new byte[][]{privateKey.getEncoded()});
        entry.put(PRIVATE_KEY_FORMAT_AT, new String[]{privateKey.getFormat()});
        LOG.debug("PrivateKey: {}", (Object)privateKey);
        PublicKey publicKey = keypair.getPublic();
        entry.put(PUBLIC_KEY_AT, (byte[][])new byte[][]{publicKey.getEncoded()});
        entry.put(PUBLIC_KEY_FORMAT_AT, new String[]{publicKey.getFormat()});
        LOG.debug("PublicKey: {}", (Object)publicKey);
        Date startDate = new Date();
        Date expiryDate = new Date(System.currentTimeMillis() + 31536000000L);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal(CERTIFICATE_PRINCIPAL_DN);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("SHA1WithRSA");
        try {
            X509Certificate cert = certGen.generate(privateKey, "BC");
            entry.put(USER_CERTIFICATE_AT, (byte[][])new byte[][]{cert.getEncoded()});
            LOG.debug("X509 Certificate: {}", (Object)cert);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Cannot generate self signed certificate.");
            ne.setRootCause(e);
            throw ne;
        }
        LOG.info("Keys and self signed certificate successfully generated.");
    }

    public static void addKeyPair(ServerEntry entry, String issuerDN, String subjectDN, String keyAlgo) throws NamingException {
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            entry.put("objectClass", new String[]{TLS_KEY_INFO_OC, "inetOrgPerson"});
        } else {
            objectClass.add(new String[]{TLS_KEY_INFO_OC, "inetOrgPerson"});
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            NamingException ne = new NamingException("Cannot generate key pair for TLS");
            ne.setRootCause(e);
            throw ne;
        }
        generator.initialize(512);
        KeyPair keypair = generator.genKeyPair();
        entry.put(KEY_ALGORITHM_AT, new String[]{keyAlgo});
        PrivateKey privateKey = keypair.getPrivate();
        entry.put(PRIVATE_KEY_AT, (byte[][])new byte[][]{privateKey.getEncoded()});
        entry.put(PRIVATE_KEY_FORMAT_AT, new String[]{privateKey.getFormat()});
        LOG.debug("PrivateKey: {}", (Object)privateKey);
        PublicKey publicKey = keypair.getPublic();
        entry.put(PUBLIC_KEY_AT, (byte[][])new byte[][]{publicKey.getEncoded()});
        entry.put(PUBLIC_KEY_FORMAT_AT, new String[]{publicKey.getFormat()});
        LOG.debug("PublicKey: {}", (Object)publicKey);
        Date startDate = new Date();
        Date expiryDate = new Date(System.currentTimeMillis() + 31536000000L);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal issuerName = new X500Principal(issuerDN);
        X500Principal subjectName = new X500Principal(subjectDN);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(issuerName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(subjectName);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("SHA1With" + keyAlgo);
        try {
            X509Certificate cert = certGen.generate(privateKey, "BC");
            entry.put(USER_CERTIFICATE_AT, (byte[][])new byte[][]{cert.getEncoded()});
            LOG.debug("X509 Certificate: {}", (Object)cert);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Cannot generate self signed certificate.");
            ne.setRootCause(e);
            throw ne;
        }
        LOG.info("Keys and self signed certificate successfully generated.");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

