/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.syntaxes.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPartitionDao {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final NumericOidSyntaxChecker NUMERIC_OID_CHECKER = new NumericOidSyntaxChecker();
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"2.5.18.3", "m-dependencies", "2.5.4.0", "2.5.4.3", "m-disabled"};
    private final Partition partition;
    private final SchemaEntityFactory factory;
    private final OidRegistry oidRegistry;
    private final AttributeTypeRegistry attrRegistry;
    private final String M_NAME_OID;
    private final String CN_OID;
    private final String M_OID_OID;
    private final String OBJECTCLASS_OID;
    private final String M_SYNTAX_OID;
    private final String M_ORDERING_OID;
    private final String M_SUBSTRING_OID;
    private final String M_EQUALITY_OID;
    private final String M_SUP_ATTRIBUTE_TYPE_OID;
    private final String M_MUST_OID;
    private final String M_MAY_OID;
    private final String M_AUX_OID;
    private final String M_OC_OID;
    private final String M_SUP_OBJECT_CLASS_OID;
    private final String M_DEPENDENCIES_OID;
    private final Set<AttributeTypeOptions> schemaAttributesToReturn = new HashSet<AttributeTypeOptions>();
    private final AttributeType disabledAttributeType;

    public SchemaPartitionDao(Partition partition, Registries registries) throws Exception {
        this.partition = partition;
        this.factory = new SchemaEntityFactory(registries);
        this.oidRegistry = registries.getOidRegistry();
        this.attrRegistry = registries.getAttributeTypeRegistry();
        this.M_NAME_OID = this.oidRegistry.getOid("m-name");
        this.CN_OID = this.oidRegistry.getOid("cn");
        this.disabledAttributeType = this.attrRegistry.lookup("m-disabled");
        this.M_OID_OID = this.oidRegistry.getOid("m-oid");
        this.OBJECTCLASS_OID = this.oidRegistry.getOid("objectClass");
        this.M_SYNTAX_OID = this.oidRegistry.getOid("m-syntax");
        this.M_ORDERING_OID = this.oidRegistry.getOid("m-ordering");
        this.M_EQUALITY_OID = this.oidRegistry.getOid("m-equality");
        this.M_SUBSTRING_OID = this.oidRegistry.getOid("m-substr");
        this.M_SUP_ATTRIBUTE_TYPE_OID = this.oidRegistry.getOid("m-supAttributeType");
        this.M_MUST_OID = this.oidRegistry.getOid("m-must");
        this.M_MAY_OID = this.oidRegistry.getOid("m-may");
        this.M_AUX_OID = this.oidRegistry.getOid("m-aux");
        this.M_OC_OID = this.oidRegistry.getOid("m-oc");
        this.M_SUP_OBJECT_CLASS_OID = this.oidRegistry.getOid("m-supObjectClass");
        this.M_DEPENDENCIES_OID = this.oidRegistry.getOid("m-dependencies");
        for (String attrId : SCHEMA_ATTRIBUTES) {
            AttributeTypeOptions ato = new AttributeTypeOptions(this.attrRegistry.lookup(attrId));
            this.schemaAttributesToReturn.add(ato);
        }
    }

    public Map<String, Schema> getSchemas() throws Exception {
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            ServerEntry sr = (ServerEntry)list.get();
            Schema schema = this.factory.getSchema(sr);
            schemas.put(schema.getSchemaName(), schema);
        }
        return schemas;
    }

    public Set<String> getSchemaNames() throws Exception {
        HashSet<String> schemaNames = new HashSet<String>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            ServerEntry sr = (ServerEntry)list.get();
            schemaNames.add(sr.get("cn").getString());
        }
        return schemaNames;
    }

    private EntryFilteringCursor listSchemas() throws Exception {
        LdapDN base = new LdapDN("ou=schema");
        base.normalize(this.attrRegistry.getNormalizerMapping());
        EqualityNode filter = new EqualityNode(this.oidRegistry.getOid("objectClass"), (Value)new ClientStringValue("metaSchema"));
        SearchOperationContext searchContext = new SearchOperationContext(null);
        searchContext.setDn(base);
        searchContext.setScope(SearchScope.ONELEVEL);
        searchContext.setReturningAttributes(this.schemaAttributesToReturn);
        searchContext.setFilter((ExprNode)filter);
        return this.partition.search(searchContext);
    }

    public Schema getSchema(String schemaName) throws Exception {
        LdapDN dn = new LdapDN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return this.factory.getSchema((ServerEntry)this.partition.lookup(new LookupOperationContext(null, dn)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMatchingRule(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaMatchingRule")));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(oid)));
        } else {
            filter.addNode((ExprNode)new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException("Got more than one matchingRule for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttributeType(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaAttributeType")));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(oid)));
        } else {
            filter.addNode((ExprNode)new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException("Got more than one attributeType for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjectClass(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaObjectClass")));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(oid)));
        } else {
            filter.addNode((ExprNode)new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException("Got more than one attributeType for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntax(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaSyntax")));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(oid)));
        } else {
            filter.addNode((ExprNode)new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException("Got more than one syntax for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxChecker(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaSyntaxChecker")));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(oid)));
        } else {
            filter.addNode((ExprNode)new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException("Got more than one syntaxChecker for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public String findSchema(String entityName) throws Exception {
        LdapDN dn = this.findDn(entityName);
        if (dn == null) {
            return null;
        }
        Rdn rdn = dn.getRdn(1);
        if (!rdn.getNormType().equalsIgnoreCase(this.CN_OID)) {
            throw new NamingException("Attribute of second rdn in dn '" + dn.toNormName() + "' expected to be CN oid of " + this.CN_OID + " but was " + rdn.getNormType());
        }
        return (String)rdn.getValue();
    }

    public LdapDN findDn(String entityName) throws Exception {
        ServerEntry sr = this.find(entityName);
        LdapDN dn = sr.getDn();
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEntry find(String entityName) throws Exception {
        OrNode filter = new OrNode();
        EqualityNode nameAVA = new EqualityNode(this.M_NAME_OID, (Value)new ClientStringValue(entityName.toLowerCase()));
        EqualityNode oidAVA = new EqualityNode(this.M_OID_OID, (Value)new ClientStringValue(entityName.toLowerCase()));
        filter.addNode((ExprNode)nameAVA);
        filter.addNode((ExprNode)oidAVA);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            if (!cursor.next()) {
                ServerEntry serverEntry = null;
                return serverEntry;
            }
            ServerEntry sr = (ServerEntry)cursor.get();
            if (cursor.next()) {
                throw new NamingException("Got more than one result for the entity name: " + entityName);
            }
            ServerEntry serverEntry = sr;
            return serverEntry;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void enableSchema(String schemaName) throws Exception {
        LdapDN dn = new LdapDN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        ClonedServerEntry entry = this.partition.lookup(new LookupOperationContext(null, dn));
        EntryAttribute disabledAttr = entry.get(this.disabledAttributeType);
        ArrayList<Modification> mods = new ArrayList<Modification>(3);
        if (disabledAttr == null) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        boolean isDisabled = disabledAttr.contains(new String[]{"TRUE"});
        if (!isDisabled) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        mods.add((Modification)new ServerModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)new DefaultServerAttribute("m-disabled", this.attrRegistry.lookup("m-disabled"))));
        mods.add((Modification)new ServerModification(ModificationOperation.ADD_ATTRIBUTE, (EntryAttribute)new DefaultServerAttribute("modifiersName", this.attrRegistry.lookup("modifiersName"), new String[]{"uid=admin,ou=system"})));
        mods.add((Modification)new ServerModification(ModificationOperation.ADD_ATTRIBUTE, (EntryAttribute)new DefaultServerAttribute("modifyTimestamp", this.attrRegistry.lookup("modifyTimestamp"), new String[]{DateUtils.getGeneralizedTime()})));
        this.partition.modify(new ModifyOperationContext(null, dn, mods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listSyntaxDependents(String numericOid) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaMatchingRule".toLowerCase())));
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaAttributeType".toLowerCase())));
        filter.addNode((ExprNode)or);
        filter.addNode((ExprNode)new EqualityNode(this.M_SYNTAX_OID, (Value)new ClientStringValue(numericOid.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listMatchingRuleDependents(MatchingRule mr) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaAttributeType".toLowerCase())));
        OrNode or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.M_ORDERING_OID, (Value)new ClientStringValue(mr.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_SUBSTRING_OID, (Value)new ClientStringValue(mr.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_EQUALITY_OID, (Value)new ClientStringValue(mr.getOid())));
        filter.addNode((ExprNode)or);
        String[] names = mr.getNamesRef();
        if (names != null || names.length > 0) {
            for (String name : names) {
                or.addNode((ExprNode)new EqualityNode(this.M_ORDERING_OID, (Value)new ClientStringValue(name.toLowerCase())));
                or.addNode((ExprNode)new EqualityNode(this.M_SUBSTRING_OID, (Value)new ClientStringValue(name.toLowerCase())));
                or.addNode((ExprNode)new EqualityNode(this.M_EQUALITY_OID, (Value)new ClientStringValue(name.toLowerCase())));
            }
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    public EntryFilteringCursor listAllNames() throws Exception {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new PresenceNode(this.M_OID_OID));
        filter.addNode((ExprNode)new PresenceNode(this.M_NAME_OID));
        return this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listAttributeTypeDependents(AttributeType at) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaAttributeType".toLowerCase())));
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaObjectClass".toLowerCase())));
        filter.addNode((ExprNode)or);
        or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.M_MAY_OID, (Value)new ClientStringValue(at.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_MUST_OID, (Value)new ClientStringValue(at.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_SUP_ATTRIBUTE_TYPE_OID, (Value)new ClientStringValue(at.getOid())));
        filter.addNode((ExprNode)or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listSchemaDependents(String schemaName) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaSchema".toLowerCase())));
        filter.addNode((ExprNode)new EqualityNode(this.M_DEPENDENCIES_OID, (Value)new ClientStringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listEnabledSchemaDependents(String schemaName) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaSchema".toLowerCase())));
        filter.addNode((ExprNode)new EqualityNode(this.M_DEPENDENCIES_OID, (Value)new ClientStringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                ServerEntry sr = (ServerEntry)cursor.get();
                EntryAttribute disabled = sr.get(this.disabledAttributeType);
                if (disabled == null) {
                    set.add(sr);
                    continue;
                }
                if (!disabled.get().equals("FALSE")) continue;
                set.add(sr);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerEntry> listObjectClassDependents(ObjectClass oc) throws Exception {
        HashSet<ServerEntry> set = new HashSet<ServerEntry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaNameForm".toLowerCase())));
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaObjectClass".toLowerCase())));
        or.addNode((ExprNode)new EqualityNode(this.OBJECTCLASS_OID, (Value)new ClientStringValue("metaDITContentRule".toLowerCase())));
        filter.addNode((ExprNode)or);
        or = new OrNode();
        or.addNode((ExprNode)new EqualityNode(this.M_AUX_OID, (Value)new ClientStringValue(oc.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_OC_OID, (Value)new ClientStringValue(oc.getOid())));
        or.addNode((ExprNode)new EqualityNode(this.M_SUP_OBJECT_CLASS_OID, (Value)new ClientStringValue(oc.getOid())));
        filter.addNode((ExprNode)or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.partition.search(new SearchOperationContext(null, this.partition.getSuffixDn(), AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, searchControls));
            while (cursor.next()) {
                set.add((ServerEntry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }
}

