/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaChecker {
    private static Logger log = LoggerFactory.getLogger(SchemaChecker.class);

    public static void preventStructuralClassRemovalOnModifyReplace(ObjectClassRegistry registry, LdapDN name, ModificationOperation mod, ServerAttribute attribute) throws NamingException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        if (!"objectClass".equalsIgnoreCase(attribute.getUpId())) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
        }
        for (Value value : attribute) {
            ObjectClass ocType = registry.lookup(value.getString());
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
    }

    public static void preventStructuralClassRemovalOnModifyReplace(ObjectClassRegistry registry, LdapDN name, ModificationOperation mod, ServerEntry entry) throws NamingException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            return;
        }
        if (objectClass.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
        }
        for (Value value : objectClass) {
            ObjectClass ocType = registry.lookup(value.getString());
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
    }

    public static void preventStructuralClassRemovalOnModifyRemove(ObjectClassRegistry registry, LdapDN name, ModificationOperation mod, EntryAttribute attribute, EntryAttribute entryObjectClasses) throws NamingException {
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        if (!((ServerAttribute)attribute).instanceOf("objectClass")) {
            return;
        }
        ArrayList<Value> removed = new ArrayList<Value>();
        for (Value value : attribute) {
            if (value.getString().length() != 0) continue;
            removed.add(value);
        }
        for (Value value : removed) {
            attribute.remove(new Value[]{value});
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
        }
        ServerAttribute cloned = (ServerAttribute)entryObjectClasses.clone();
        for (Value value : attribute) {
            cloned.remove(new Value[]{value});
        }
        for (Value objectClass : cloned) {
            ObjectClass oc = registry.lookup(objectClass.getString());
            if (oc.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED);
    }

    public static void preventRdnChangeOnModifyReplace(LdapDN name, ModificationOperation mod, ServerAttribute attribute, OidRegistry oidRegistry) throws NamingException {
        String id;
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        if (!rdnAttributes.contains(id = oidRegistry.getOid(attribute.getUpId()))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation attempts to delete RDN attribute ";
            msg = msg + id + " on entry " + name + " violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
        for (int ii = 0; ii < attribute.size(); ++ii) {
            if (attribute.contains(new String[]{rdnValue})) continue;
            String msg = "Modify operation attempts to delete RDN attribute values in use for ";
            msg = msg + id + " on entry " + name + " and violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
        }
    }

    public static void preventRdnChangeOnModifyReplace(LdapDN name, ModificationOperation mod, ServerEntry entry, OidRegistry oidRegistry) throws NamingException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            String id = attributeType.getName();
            if (!rdnAttributes.contains(id)) continue;
            EntryAttribute rdnAttr = entry.get(id);
            if (rdnAttr.size() == 0) {
                String msg = "Modify operation attempts to delete RDN attribute ";
                msg = msg + id + " on entry " + name + " violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
            if (rdnAttr.contains(new String[]{rdnValue})) continue;
            String msg = "Modify operation attempts to delete RDN attribute values in use for ";
            msg = msg + id + " on entry " + name + " and violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
        }
    }

    public static void preventRdnChangeOnModifyRemove(LdapDN name, ModificationOperation mod, ServerAttribute attribute, OidRegistry oidRegistry) throws NamingException {
        String id;
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        if (!rdnAttributes.contains(oidRegistry.getOid(id = attribute.getId()))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation attempts to delete RDN attribute ";
            msg = msg + id + " on entry " + name + " violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
        for (Value value : attribute) {
            if (!rdnValue.equals(value.getString())) continue;
            String msg = "Modify operation attempts to delete RDN attribute values in use for ";
            msg = msg + id + " on entry " + name + " and violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
        }
    }

    public static void preventRdnChangeOnModifyRemove(LdapDN name, ModificationOperation mod, ServerEntry entry, OidRegistry oidRegistry) throws NamingException {
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            String id = attributeType.getName();
            if (!rdnAttributes.contains(id)) continue;
            if (entry.get(id).size() == 0) {
                String msg = "Modify operation attempts to delete RDN attribute ";
                msg = msg + id + " on entry " + name + " violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
            EntryAttribute rdnAttr = entry.get(id);
            for (Value value : rdnAttr) {
                if (!rdnValue.equals(value.getString())) continue;
                String msg = "Modify operation attempts to delete RDN attribute values in use for ";
                msg = msg + id + " on entry " + name + " and violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
        }
    }

    private static String getRdnValue(String id, LdapDN name, OidRegistry oidRegistry) throws NamingException {
        String idOid = oidRegistry.getOid(id);
        if (idOid == null) {
            log.error("The id {} does not have any OID. It should be a wrong AttributeType.", (Object)id);
            throw new NamingException("Wrong AttributeType, does not have an associated OID : " + id);
        }
        String[] comps = NamespaceTools.getCompositeComponents((String)name.get(name.size() - 1));
        for (int ii = 0; ii < comps.length; ++ii) {
            String rdnAttrId = NamespaceTools.getRdnAttribute((String)comps[ii]);
            String rdnAttrOid = oidRegistry.getOid(rdnAttrId);
            if (rdnAttrOid == null) {
                log.error("The id {} does not have any OID. It should be a wrong AttributeType.", (Object)rdnAttrOid);
                throw new NamingException("Wrong AttributeType, does not have an associated OID : " + rdnAttrOid);
            }
            if (!rdnAttrOid.equalsIgnoreCase(idOid)) continue;
            return NamespaceTools.getRdnValue((String)comps[ii]);
        }
        return null;
    }

    private static Set<String> getRdnAttributes(LdapDN name) throws NamingException {
        String[] comps = NamespaceTools.getCompositeComponents((String)name.get(name.size() - 1));
        HashSet<String> attributes = new HashSet<String>();
        for (int ii = 0; ii < comps.length; ++ii) {
            attributes.add(NamespaceTools.getRdnAttribute((String)comps[ii]));
        }
        return attributes;
    }
}

