/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class MetaNormalizerHandler
extends AbstractSchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final NormalizerRegistry normalizerRegistry;
    private final MatchingRuleRegistry matchingRuleRegistry;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;

    public MetaNormalizerHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws Exception {
        super(targetRegistries, loader);
        this.normalizerRegistry = targetRegistries.getNormalizerRegistry();
        this.matchingRuleRegistry = targetRegistries.getMatchingRuleRegistry();
        this.factory = new SchemaEntityFactory(targetRegistries);
        this.byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = targetRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = targetRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
    }

    private NormalizerDescription getNormalizerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        NormalizerDescription description = new NormalizerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Normalizer normalizer = this.factory.getNormalizer(targetEntry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            this.normalizerRegistry.unregister(oid);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), targetEntry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
            return true;
        }
        return false;
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUniqueForNormalizer(entry);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), entry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void add(NormalizerDescription normalizerDescription) throws Exception {
        Schema schema;
        Normalizer normalizer = this.factory.getNormalizer(normalizerDescription, this.targetRegistries);
        String schemaName = "other";
        if (normalizerDescription.getExtensions().get("X-SCHEMA") != null) {
            schemaName = (String)((List)normalizerDescription.getExtensions().get("X-SCHEMA")).get(0);
        }
        if (!(schema = this.loader.getSchema(schemaName)).isDisabled()) {
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        this.delete(this.getOid(entry), cascade);
    }

    public void delete(String oid, boolean cascade) throws NamingException {
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oid + " cannot be deleted until all " + "matchingRules using that normalizer have also been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (this.normalizerRegistry.hasNormalizer(oid)) {
            this.normalizerRegistry.unregister(oid);
        }
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = (String)newRdn.getValue();
        this.checkOidIsUniqueForNormalizer(oid);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
            this.normalizerRegistry.unregister(oldOid);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), entry);
            normalizerDescription.setNumericOid(oid);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = (String)newRdn.getValue();
        this.checkOidIsUniqueForNormalizer(oid);
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.normalizerRegistry.unregister(oldOid);
        }
        if (!newSchema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(newSchema.getSchemaName(), entry);
            normalizerDescription.setNumericOid(oid);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The normalizer with OID " + oid + " cannot be moved to another schema until all " + "matchingRules using that normalizer have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Normalizer normalizer = this.factory.getNormalizer(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.normalizerRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(newSchema.getSchemaName(), entry);
            this.normalizerRegistry.register(normalizerDescription, normalizer);
        }
    }

    private void checkOidIsUniqueForNormalizer(String oid) throws NamingException {
        if (this.targetRegistries.getNormalizerRegistry().hasNormalizer(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema normalizer is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkOidIsUniqueForNormalizer(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getNormalizerRegistry().hasNormalizer(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema normalizer is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a normalizer should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a normalizer should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("normalizers")) {
            throw new LdapInvalidNameException("The parent entry of a normalizer should have a relative name of ou=normalizers.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

