/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchingOperationContext
extends AbstractOperationContext {
    private static Logger LOG = LoggerFactory.getLogger(SearchingOperationContext.class);
    private static String[] EMPTY_STR_ARRAY = new String[0];
    protected AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    protected long sizeLimit = 0L;
    protected int timeLimit = 0;
    protected SearchScope scope = SearchScope.ONELEVEL;
    protected boolean allOperationalAttributes = false;
    protected boolean allUserAttributes = false;
    protected boolean noAttributes = false;
    protected Set<AttributeTypeOptions> returningAttributes;
    protected boolean abandoned = false;

    public SearchingOperationContext(CoreSession session) {
        super(session);
    }

    public SearchingOperationContext(CoreSession session, LdapDN dn) {
        super(session, dn);
    }

    public SearchingOperationContext(CoreSession session, LdapDN dn, AliasDerefMode aliasDerefMode) {
        super(session, dn);
        this.aliasDerefMode = aliasDerefMode;
    }

    protected void setReturningAttributes(Collection<String> attributesIds) throws Exception {
        this.setReturningAttributes(attributesIds.toArray(EMPTY_STR_ARRAY));
    }

    protected void setReturningAttributes(String[] attributesIds) throws Exception {
        if (attributesIds != null && attributesIds.length != 0) {
            this.returningAttributes = new HashSet<AttributeTypeOptions>();
            for (String returnAttribute : attributesIds) {
                if (returnAttribute.equals("1.1")) {
                    this.noAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("+")) {
                    this.allOperationalAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("*")) {
                    this.allUserAttributes = true;
                    continue;
                }
                try {
                    String id = SchemaUtils.stripOptions((String)returnAttribute);
                    Set options = SchemaUtils.getOptions((String)returnAttribute);
                    AttributeType attributeType = this.session.getDirectoryService().getRegistries().getAttributeTypeRegistry().lookup(id);
                    AttributeTypeOptions attrOptions = new AttributeTypeOptions(attributeType, options);
                    this.returningAttributes.add(attrOptions);
                }
                catch (NoSuchAttributeException nsae) {
                    LOG.warn("Requested attribute {} does not exist in the schema, it will be ignored", (Object)returnAttribute);
                }
            }
        }
    }

    public SearchingOperationContext(CoreSession session, LdapDN dn, AliasDerefMode aliasDerefMode, SearchControls searchControls) throws Exception {
        super(session, dn);
        this.aliasDerefMode = aliasDerefMode;
        this.scope = SearchScope.getSearchScope((SearchControls)searchControls);
        this.timeLimit = searchControls.getTimeLimit();
        this.sizeLimit = searchControls.getCountLimit();
        if (searchControls.getReturningAttributes() != null) {
            this.setReturningAttributes(searchControls.getReturningAttributes());
        }
    }

    public SearchingOperationContext(CoreSession session, LdapDN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) {
        super(session, dn);
        this.aliasDerefMode = aliasDerefMode;
        this.returningAttributes = returningAttributes;
    }

    public String toString() {
        return "ListOperationContext with DN '" + this.getDn().getUpName() + "'";
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setAllOperationalAttributes(boolean allOperationalAttribute) {
        this.allOperationalAttributes = allOperationalAttribute;
    }

    public boolean isAllOperationalAttributes() {
        return this.allOperationalAttributes;
    }

    public void setAllUserAttributes(boolean allUserAttributes) {
        this.allUserAttributes = allUserAttributes;
    }

    public boolean isAllUserAttributes() {
        return this.allUserAttributes;
    }

    public void setNoAttributes(boolean noAttributes) {
        this.noAttributes = noAttributes;
    }

    public boolean isNoAttributes() {
        return this.noAttributes;
    }

    public void setReturningAttributes(Set<AttributeTypeOptions> returningAttributes) {
        this.returningAttributes = returningAttributes;
    }

    public Set<AttributeTypeOptions> getReturningAttributes() {
        return this.returningAttributes;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean denormalized) {
        SearchControls controls = new SearchControls();
        controls.setCountLimit(this.sizeLimit);
        controls.setSearchScope(this.scope.getJndiScope());
        controls.setTimeLimit(this.timeLimit);
        HashSet<String> allReturningAttributes = new HashSet<String>();
        if (this.noAttributes) {
            allReturningAttributes.add("1.1");
        }
        if (this.allUserAttributes) {
            allReturningAttributes.add("*");
        }
        if (this.allOperationalAttributes) {
            allReturningAttributes.add("+");
        }
        if (this.returningAttributes != null) {
            for (AttributeTypeOptions at : this.returningAttributes) {
                if (denormalized) {
                    allReturningAttributes.add(at.getAttributeType().getName());
                    continue;
                }
                allReturningAttributes.add(at.getAttributeType().getOid());
            }
        }
        if (allReturningAttributes.size() > 0) {
            controls.setReturningAttributes(allReturningAttributes.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        return controls;
    }

    public void setAbandoned(boolean abandoned) {
        this.abandoned = abandoned;
    }

    public boolean isAbandoned() {
        return this.abandoned;
    }
}

