/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedProtectedItemFilter
implements ACITupleFilter {
    private final RefinementEvaluator refinementEvaluator;
    private final Evaluator entryEvaluator;
    private final OidRegistry oidRegistry;
    private final AttributeTypeRegistry attrRegistry;

    public RelatedProtectedItemFilter(RefinementEvaluator refinementEvaluator, Evaluator entryEvaluator, OidRegistry oidRegistry, AttributeTypeRegistry attrRegistry) {
        this.refinementEvaluator = refinementEvaluator;
        this.entryEvaluator = entryEvaluator;
        this.oidRegistry = oidRegistry;
        this.attrRegistry = attrRegistry;
    }

    @Override
    public Collection<ACITuple> filter(Registries registries, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<LdapDN> userGroupNames, LdapDN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> i = tuples.iterator();
        while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (this.isRelated(tuple, scope, userName, entryName, attrId, attrValue, entry)) continue;
            i.remove();
        }
        return tuples;
    }

    private boolean isRelated(ACITuple tuple, OperationScope scope, LdapDN userName, LdapDN entryName, String attrId, Value<?> attrValue, ServerEntry entry) throws NamingException, InternalError {
        String oid = null;
        if (attrId != null) {
            oid = this.oidRegistry.getOid(attrId);
        }
        for (ProtectedItem item : tuple.getProtectedItems()) {
            Iterator j;
            if (item == ProtectedItem.ENTRY) {
                if (scope != OperationScope.ENTRY) continue;
                return true;
            }
            if (item == ProtectedItem.ALL_USER_ATTRIBUTE_TYPES) {
                if (scope != OperationScope.ATTRIBUTE_TYPE && scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                return true;
            }
            if (item == ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES) {
                if (scope != OperationScope.ATTRIBUTE_TYPE && scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                return true;
            }
            if (item instanceof ProtectedItem.AllAttributeValues) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                ProtectedItem.AllAttributeValues aav = (ProtectedItem.AllAttributeValues)item;
                j = aav.iterator();
                while (j.hasNext()) {
                    if (!oid.equals(this.oidRegistry.getOid((String)j.next()))) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ProtectedItem.AttributeType) {
                if (scope != OperationScope.ATTRIBUTE_TYPE) continue;
                ProtectedItem.AttributeType at = (ProtectedItem.AttributeType)item;
                j = at.iterator();
                while (j.hasNext()) {
                    if (!oid.equals(this.oidRegistry.getOid((String)j.next()))) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ProtectedItem.AttributeValue) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                ProtectedItem.AttributeValue av = (ProtectedItem.AttributeValue)item;
                for (Attribute attr : av) {
                    String attrOid = this.oidRegistry.getOid(attr.getID());
                    AttributeType attrType = this.attrRegistry.lookup(attrOid);
                    if (!oid.equals(attrOid) || !AttributeUtils.containsValue((Attribute)attr, attrValue, (AttributeType)attrType)) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ProtectedItem.Classes) {
                ProtectedItem.Classes c = (ProtectedItem.Classes)item;
                if (!this.refinementEvaluator.evaluate(c.getClasses(), entry.get("objectClass"))) continue;
                return true;
            }
            if (item instanceof ProtectedItem.MaxImmSub) {
                return true;
            }
            if (item instanceof ProtectedItem.MaxValueCount) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                ProtectedItem.MaxValueCount mvc = (ProtectedItem.MaxValueCount)item;
                for (ProtectedItem.MaxValueCountItem mvcItem : mvc) {
                    if (!oid.equals(this.oidRegistry.getOid(mvcItem.getAttributeType()))) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ProtectedItem.RangeOfValues) {
                ProtectedItem.RangeOfValues rov = (ProtectedItem.RangeOfValues)item;
                if (!this.entryEvaluator.evaluate(rov.getFilter(), entryName.toString(), entry)) continue;
                return true;
            }
            if (item instanceof ProtectedItem.RestrictedBy) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                ProtectedItem.RestrictedBy rb = (ProtectedItem.RestrictedBy)item;
                for (ProtectedItem.RestrictedByItem rbItem : rb) {
                    if (!oid.equals(this.oidRegistry.getOid(rbItem.getAttributeType()))) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ProtectedItem.SelfValue) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE && scope != OperationScope.ATTRIBUTE_TYPE) continue;
                ProtectedItem.SelfValue sv = (ProtectedItem.SelfValue)item;
                for (String svItem : sv) {
                    EntryAttribute attr;
                    if (!oid.equals(this.oidRegistry.getOid(svItem)) || (attr = entry.get(oid)) == null || !attr.contains(new String[]{userName.toNormName()}) && !attr.contains(new String[]{userName.getUpName()})) continue;
                    return true;
                }
                continue;
            }
            throw new InternalError("Unexpected protectedItem: " + item.getClass().getName());
        }
        return false;
    }
}

