/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleCache {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCache.class);
    private final Map<String, List<ACITuple>> tuples = new HashMap<String, List<ACITuple>>();
    private final PartitionNexus nexus;
    private final ACIItemParser aciParser;
    private AttributeType prescriptiveAciAT;
    private Map<String, OidNormalizer> normalizerMap;

    public TupleCache(CoreSession session) throws Exception {
        this.normalizerMap = session.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = session.getDirectoryService().getPartitionNexus();
        AttributeTypeRegistry attributeTypeRegistry = session.getDirectoryService().getRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = session.getDirectoryService().getRegistries().getOidRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(attributeTypeRegistry, oidRegistry);
        this.aciParser = new ACIItemParser((NameComponentNormalizer)ncn, this.normalizerMap);
        this.prescriptiveAciAT = attributeTypeRegistry.lookup("prescriptiveACI");
        this.initialize(session);
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize(CoreSession session) throws Exception {
        Set<String> suffixes = this.nexus.listSuffixes(null);
        for (String suffix : suffixes) {
            LdapDN baseDn = this.parseNormalized(suffix);
            EqualityNode filter = new EqualityNode("objectClass", (Value)new ClientStringValue("accessControlSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            EntryFilteringCursor results = this.nexus.search(new SearchOperationContext(session, baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, ctls));
            while (results.next()) {
                ServerEntry result = (ServerEntry)results.get();
                LdapDN subentryDn = result.getDn().normalize(this.normalizerMap);
                EntryAttribute aci = result.get(this.prescriptiveAciAT);
                if (aci == null) {
                    LOG.warn("Found accessControlSubentry '" + subentryDn + "' without any " + "prescriptiveACI");
                    continue;
                }
                this.subentryAdded(subentryDn, result);
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveACI(ServerEntry entry) throws NamingException {
        EntryAttribute aci = entry.get(this.prescriptiveAciAT);
        if (aci == null) {
            if (entry.contains("objectClass", new String[]{"accessControlSubentry"}) || entry.contains("objectClass", new String[]{"2.5.17.1"})) {
                throw new LdapSchemaViolationException("", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
            }
            return false;
        }
        return true;
    }

    public void subentryAdded(LdapDN normName, ServerEntry entry) throws NamingException {
        EntryAttribute aciAttr = entry.get(this.prescriptiveAciAT);
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        ArrayList entryTuples = new ArrayList();
        for (Value value : aciAttr) {
            String aci = value.getString();
            ACIItem item = null;
            try {
                item = this.aciParser.parse(aci);
                entryTuples.addAll(item.toTuples());
            }
            catch (ParseException e) {
                String msg = "ACIItem parser failure on \n'" + item + "'\ndue to syntax error. " + "Cannnot add ACITuples to TupleCache.\n" + "Check that the syntax of the ACI item is correct. \nUntil this error " + "is fixed your security settings will not be as expected.";
                LOG.error(msg, (Throwable)e);
            }
        }
        this.tuples.put(normName.toNormName(), entryTuples);
    }

    public void subentryDeleted(LdapDN normName, ServerEntry entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        this.tuples.remove(normName.toString());
    }

    public void subentryModified(LdapDN normName, List<Modification> mods, ServerEntry entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        for (Modification mod : mods) {
            if (!((ServerAttribute)mod.getAttribute()).instanceOf("prescriptiveACI")) continue;
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public void subentryModified(LdapDN normName, ServerEntry mods, ServerEntry entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        if (mods.get(this.prescriptiveAciAT) != null) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<ACITuple> getACITuples(String subentryDn) {
        List<ACITuple> aciTuples = this.tuples.get(subentryDn);
        if (aciTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aciTuples);
    }

    public void subentryRenamed(LdapDN oldName, LdapDN newName) {
        this.tuples.put(newName.toString(), this.tuples.remove(oldName.toString()));
    }
}

