/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.tree.DnBranchNode;

public class ReferralManagerImpl
implements ReferralManager {
    private DnBranchNode<ServerEntry> referrals;
    private ReentrantReadWriteLock mutex = new ReentrantReadWriteLock();

    public ReferralManagerImpl(DirectoryService directoryService) throws Exception {
        this.lockWrite();
        this.referrals = new DnBranchNode();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        Set<String> suffixes = nexus.listSuffixes(null);
        this.init(directoryService, suffixes.toArray(new String[0]));
        this.unlock();
    }

    public void lockRead() {
        this.mutex.readLock().lock();
    }

    public void lockWrite() {
        this.mutex.writeLock().lock();
    }

    public void unlock() {
        if (this.mutex.isWriteLockedByCurrentThread()) {
            this.mutex.writeLock().unlock();
        } else {
            this.mutex.readLock().unlock();
        }
    }

    public void addReferral(ServerEntry entry) {
        try {
            this.referrals.add(entry.getDn(), (Object)entry);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void init(DirectoryService directoryService, String ... suffixes) throws Exception {
        EqualityNode referralFilter = new EqualityNode("objectClass", (Value)new ClientStringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        for (String suffix : suffixes) {
            LdapDN suffixDn = new LdapDN(suffix);
            EntryFilteringCursor cursor = nexus.search(new SearchOperationContext(adminSession, suffixDn, AliasDerefMode.DEREF_ALWAYS, (ExprNode)referralFilter, searchControl));
            cursor.beforeFirst();
            while (cursor.next()) {
                ServerEntry entry = (ServerEntry)cursor.get();
                this.lockWrite();
                this.addReferral(entry);
                this.unlock();
            }
        }
    }

    public void remove(DirectoryService directoryService, LdapDN suffix) throws Exception {
        EqualityNode referralFilter = new EqualityNode("objectClass", (Value)new ClientStringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        EntryFilteringCursor cursor = nexus.search(new SearchOperationContext(adminSession, suffix, AliasDerefMode.DEREF_ALWAYS, (ExprNode)referralFilter, searchControl));
        cursor.beforeFirst();
        while (cursor.next()) {
            ServerEntry entry = (ServerEntry)cursor.get();
            this.removeReferral(entry);
        }
    }

    public boolean hasParentReferral(LdapDN dn) {
        return this.referrals.hasParentElement(dn);
    }

    public ServerEntry getParentReferral(LdapDN dn) {
        if (!this.hasParentReferral(dn)) {
            return null;
        }
        return (ServerEntry)this.referrals.getParentElement(dn);
    }

    public boolean isReferral(LdapDN dn) {
        ServerEntry parent = (ServerEntry)this.referrals.getParentElement(dn);
        if (parent != null) {
            return dn.equals((Object)parent.getDn());
        }
        return false;
    }

    public void removeReferral(ServerEntry entry) {
        this.referrals.remove((Object)entry);
    }
}

