/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.ClassLoaderLock;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.JarLoader;

final class UpdateLoader
implements LockOwner {
    private static final String[] RESTRICTED_PACKAGES = new String[]{"javax.", "org.apache.derby."};
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final LockFactory lf;
    private final ShExLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private final CompatibilitySpace compat;
    private boolean needReload;
    private JarReader jarReader;

    UpdateLoader(String string, DatabaseClasses databaseClasses, boolean bl, boolean bl2) throws StandardException {
        this.normalizeToUpper = bl2;
        this.parent = databaseClasses;
        this.lf = (LockFactory)Monitor.getServiceModule(databaseClasses, "org.apache.derby.iapi.services.locks.LockFactory");
        CompatibilitySpace compatibilitySpace = this.compat = this.lf != null ? this.lf.createCompatibilitySpace(this) : null;
        if (bl) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new ClassLoaderLock(this);
        this.initializeFromClassPath(string);
    }

    private void initializeFromClassPath(String string) throws StandardException {
        final String[][] stringArray = IdUtil.parseDbClassPath(string);
        final int n = stringArray.length;
        this.jarList = new JarLoader[n];
        if (n != 0) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int i = 0; i < n; ++i) {
                        ((UpdateLoader)UpdateLoader.this).jarList[i] = new JarLoader(UpdateLoader.this, stringArray[i], UpdateLoader.this.vs);
                    }
                    return null;
                }
            });
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C005", string));
        }
        this.thisClasspath = string;
        this.initDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        UpdateLoader updateLoader;
        boolean bl2;
        block17: {
            Class clazz;
            block16: {
                JarLoader jarLoader = null;
                bl2 = false;
                try {
                    try {
                        bl2 = this.lockClassLoader(ShExQual.SH);
                        updateLoader = this;
                        synchronized (updateLoader) {
                            Class clazz2;
                            if (this.needReload) {
                                this.reload();
                            }
                            if ((clazz2 = this.checkLoaded(string, bl)) != null) {
                                Class clazz3 = clazz2;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                                Object var13_11 = null;
                                if (!bl2) return clazz3;
                                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                                return clazz3;
                            }
                            for (int i = 0; i < RESTRICTED_PACKAGES.length; ++i) {
                                if (!string.startsWith(RESTRICTED_PACKAGES[i])) continue;
                                throw new ClassNotFoundException(string);
                            }
                            String string2 = string.replace('.', '/').concat(".class");
                            if (!this.initDone) {
                                this.initLoaders();
                            }
                            for (int i = 0; i < this.jarList.length; ++i) {
                                jarLoader = this.jarList[i];
                                Class clazz4 = jarLoader.loadClassData(string, string2, bl);
                                if (clazz4 == null) continue;
                                if (this.vs != null) {
                                    this.vs.println(MessageService.getTextMessage("C006", string, jarLoader.getJarName()));
                                }
                                clazz = clazz4;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 9] lbl31 : MonitorExitStatement: MONITOREXIT : var5_5
                                break block16;
                            }
                        }
                        updateLoader = null;
                        break block17;
                    }
                    catch (StandardException standardException) {
                        String string3;
                        if (jarLoader == null) {
                            string3 = null;
                            throw new ClassNotFoundException(MessageService.getTextMessage("C007", string, string3, standardException));
                        }
                        string3 = jarLoader.getJarName();
                        throw new ClassNotFoundException(MessageService.getTextMessage("C007", string, string3, standardException));
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!bl2) throw throwable;
                    this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                    throw throwable;
                }
            }
            Object var13_12 = null;
            if (!bl2) return clazz;
            this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            return clazz;
        }
        Object var13_13 = null;
        if (!bl2) return updateLoader;
        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
        return updateLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream getResourceAsStream(String string) {
        UpdateLoader updateLoader;
        InputStream inputStream;
        InputStream inputStream2 = inputStream = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(string) : this.myLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (string.endsWith(".class")) {
            return null;
        }
        boolean bl = false;
        try {
            try {
                bl = this.lockClassLoader(ShExQual.SH);
                updateLoader = this;
                synchronized (updateLoader) {
                    if (this.needReload) {
                        this.reload();
                    }
                    if (!this.initDone) {
                        this.initLoaders();
                    }
                    for (int i = 0; i < this.jarList.length; ++i) {
                        JarLoader jarLoader = this.jarList[i];
                        inputStream = jarLoader.getStream(string);
                        if (inputStream == null) continue;
                        InputStream inputStream3 = inputStream;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var4_4
                        Object var10_10 = null;
                        if (!bl) return inputStream3;
                        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                        return inputStream3;
                    }
                }
                updateLoader = null;
            }
            catch (StandardException standardException) {
                InputStream inputStream4 = null;
                Object var10_12 = null;
                if (!bl) return inputStream4;
                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                return inputStream4;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!bl) throw throwable;
            this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            throw throwable;
        }
        Object var10_11 = null;
        if (!bl) return updateLoader;
        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
        return updateLoader;
    }

    synchronized void modifyClasspath(String string) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        this.modifyJar(false);
        this.initializeFromClassPath(string);
    }

    synchronized void modifyJar(boolean bl) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        if (!this.initDone) {
            return;
        }
        this.close();
        if (bl) {
            this.initializeFromClassPath(this.thisClasspath);
        }
    }

    private boolean lockClassLoader(ShExQual shExQual) throws StandardException {
        if (this.lf == null) {
            return false;
        }
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        CompatibilitySpace compatibilitySpace = null;
        if (classFactoryContext != null) {
            compatibilitySpace = classFactoryContext.getLockSpace();
        }
        if (compatibilitySpace == null) {
            compatibilitySpace = this.compat;
        }
        LockOwner lockOwner = compatibilitySpace.getOwner();
        this.lf.lockObject(compatibilitySpace, lockOwner, this.classLoaderLock, shExQual, -2);
        return lockOwner == this;
    }

    Class checkLoaded(String string, boolean bl) {
        for (int i = 0; i < this.jarList.length; ++i) {
            Class clazz = this.jarList[i].checkLoaded(string, bl);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    void close() {
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].setInvalid();
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].initialize();
        }
        this.initDone = true;
    }

    int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        PersistentSet persistentSet = classFactoryContext.getPersistentSet();
        String string = PropertyUtil.getServiceProperty(persistentSet, "derby.database.classpath");
        if (string == null) {
            string = "";
        }
        return string;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
            this.jarReader = classFactoryContext.getJarReader();
        }
        return this.jarReader;
    }

    public boolean noWait() {
        return false;
    }
}

