/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper;

import javax.jws.soap.SOAPBinding;
import javax.wsdl.OperationType;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;

public final class MethodMapper {
    public JavaMethod map(OperationInfo operation) {
        JavaMethod method = new JavaMethod();
        method.setSoapStyle(SOAPBinding.Style.DOCUMENT);
        String operationName = operation.getName().getLocalPart();
        method.setName(ProcessorUtil.mangleNameToVariableName(operationName));
        method.setOperationName(operationName);
        JAXWSBinding opBinding = (JAXWSBinding)operation.getExtensor(JAXWSBinding.class);
        if (opBinding != null && opBinding.getMethodName() != null) {
            method.setName(opBinding.getMethodName());
        }
        if (opBinding != null && opBinding.getMethodJavaDoc() != null) {
            method.setJavaDoc(opBinding.getMethodJavaDoc());
        }
        if (operation.isOneWay()) {
            method.setStyle(OperationType.ONE_WAY);
        } else {
            method.setStyle(OperationType.REQUEST_RESPONSE);
        }
        method.setWrapperStyle(operation.isUnwrappedCapable());
        return method;
    }
}

