/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

@Produces(value={"text/html"})
@Provider
public class SpringViewResolverProvider
extends AbstractConfigurableProvider
implements MessageBodyWriter<Object> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SpringViewResolverProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(SpringViewResolverProvider.class);
    private static final String MESSAGE_RESOURCE_PATH_PROPERTY = "redirect.resource.path";
    private static final String DEFAULT_RESOURCE_EXTENSION = "";
    private static final String DEFAULT_LOCATION_PREFIX = "";
    private final ViewResolver viewResolver;
    private String resourcePath;
    private Map<String, String> resourcePaths = Collections.emptyMap();
    private Map<String, String> classResources = Collections.emptyMap();
    private Map<? extends Enum<?>, String> enumResources = Collections.emptyMap();
    private boolean useClassNames;
    private Map<String, String> beanNames = Collections.emptyMap();
    private String beanName;
    private boolean logRedirects;
    private boolean strictPathCheck;
    private String locationPrefix;
    private String resourceExtension;
    private MessageContext mc;
    private LocaleResolver localeResolver;
    private String errorView = "/error";

    public SpringViewResolverProvider(ViewResolver viewResolver, LocaleResolver localeResolver) {
        if (viewResolver == null) {
            throw new IllegalArgumentException("Argument viewResolver is required");
        }
        if (localeResolver == null) {
            throw new IllegalArgumentException("Argument localeResolver is required");
        }
        this.viewResolver = viewResolver;
        this.localeResolver = localeResolver;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public void setStrictPathCheck(boolean use) {
        this.strictPathCheck = use;
    }

    public void setUseClassNames(boolean use) {
        this.useClassNames = use;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    private String getViewName(Class<?> type) {
        String viewName = this.doGetClassResourceName(type);
        if (viewName == null) {
            Class<?> in;
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (viewName = this.doGetClassResourceName(in = classArray[i])) == null; ++i) {
            }
        }
        return viewName;
    }

    private Locale getLocale() {
        return this.localeResolver.resolveLocale(this.mc.getHttpServletRequest());
    }

    private String doGetClassResourceName(Class<?> type) {
        String simpleName = StringUtils.uncapitalize((String)type.getSimpleName());
        String thePrefix = this.locationPrefix == null ? "" : this.locationPrefix;
        String theExtension = this.resourceExtension == null ? "" : this.resourceExtension;
        String viewName = thePrefix + simpleName + theExtension;
        View view = this.resolveView(viewName);
        return view != null ? viewName : null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (this.useClassNames && this.getViewName(type) != null) {
            return true;
        }
        if (this.resourcePath != null || this.classResourceSupported(type)) {
            return true;
        }
        if (!this.resourcePaths.isEmpty()) {
            String path = this.getRequestPath();
            for (String requestPath : this.resourcePaths.keySet()) {
                boolean result = this.strictPathCheck ? path.endsWith(requestPath) : path.contains(requestPath);
                if (!result) continue;
                return true;
            }
        }
        return this.mc != null && this.mc.get(MESSAGE_RESOURCE_PATH_PROPERTY) != null;
    }

    private boolean classResourceSupported(Class<?> type) {
        String typeName = type.getName();
        if (type.isEnum()) {
            for (Enum<?> o : this.enumResources.keySet()) {
                if (!o.getClass().getName().equals(typeName)) continue;
                return true;
            }
            for (String name : this.classResources.keySet()) {
                if (!name.startsWith(typeName)) continue;
                return true;
            }
            return false;
        }
        return this.classResources.containsKey(typeName);
    }

    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        View view = this.getView(clazz, o);
        String attributeName = this.getBeanName(o);
        Map<String, Object> model = Collections.singletonMap(attributeName, o);
        try {
            this.mc.put("http.request.redirected", Boolean.TRUE);
            this.logRedirection(view, attributeName, o);
            view.render(model, this.mc.getHttpServletRequest(), this.mc.getHttpServletResponse());
        }
        catch (Throwable ex) {
            this.handleViewRenderingException(view, ex);
        }
    }

    private void handleViewRenderingException(View view, Throwable exception) {
        LOG.log(Level.WARNING, String.format("Error forwarding to '%s': %s", view, exception.getMessage()), exception);
        if (this.errorView != null) {
            this.mc.getHttpServletRequest().setAttribute("javax.servlet.error.exception", (Object)exception);
            this.mc.getHttpServletRequest().setAttribute("javax.servlet.error.status_code", (Object)500);
            this.mc.getHttpServletRequest().setAttribute("javax.servlet.error.message", (Object)exception.getMessage());
            try {
                this.mc.getServletContext().getRequestDispatcher(this.errorView).forward((ServletRequest)this.mc.getHttpServletRequest(), (ServletResponse)this.mc.getHttpServletResponse());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error forwarding to error page '%s': %s", this.errorView, e.toString()), e);
                this.handleInternalViewRenderingException(exception);
            }
        } else {
            this.handleInternalViewRenderingException(exception);
        }
    }

    private void handleInternalViewRenderingException(Throwable exception) {
        this.mc.put("http.request.redirected", Boolean.FALSE);
        throw ExceptionUtils.toInternalServerErrorException(exception, null);
    }

    private void logRedirection(View view, String attributeName, Object o) {
        Level level;
        Level level2 = level = this.logRedirects ? Level.INFO : Level.FINE;
        if (LOG.isLoggable(level)) {
            String message = new org.apache.cxf.common.i18n.Message("RESPONSE_REDIRECTED_TO", BUNDLE, new Object[]{o.getClass().getName(), attributeName, view}).toString();
            LOG.log(level, message);
        }
    }

    View getView(Class<?> cls, Object o) {
        String currentResourcePath = this.getPathFromMessageContext();
        if (currentResourcePath != null) {
            return this.resolveView(currentResourcePath);
        }
        if (!this.resourcePaths.isEmpty()) {
            String path = this.getRequestPath();
            for (Map.Entry<String, String> entry : this.resourcePaths.entrySet()) {
                if (!path.endsWith(entry.getKey())) continue;
                return this.resolveView(entry.getValue());
            }
        }
        if (!this.enumResources.isEmpty() || !this.classResources.isEmpty()) {
            String clsResourcePath;
            String name = cls.getName();
            if (cls.isEnum()) {
                String enumResource = this.enumResources.get(o);
                if (enumResource != null) {
                    return this.resolveView(enumResource);
                }
                name = name + "." + o.toString();
            }
            if ((clsResourcePath = this.classResources.get(name)) != null) {
                return this.resolveView(clsResourcePath);
            }
        }
        if (this.useClassNames) {
            return this.resolveView(this.getViewName(cls));
        }
        return this.resolveView(this.resourcePath);
    }

    private View resolveView(String viewName) {
        try {
            return this.viewResolver.resolveViewName(viewName, this.getLocale());
        }
        catch (Exception ex) {
            LOG.warning(ExceptionUtils.getStackTrace(ex));
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    private String getPathFromMessageContext() {
        Object resourcePathProp;
        if (this.mc != null && (resourcePathProp = this.mc.get(MESSAGE_RESOURCE_PATH_PROPERTY)) != null) {
            StringBuilder sb = new StringBuilder();
            if (this.locationPrefix != null) {
                sb.append(this.locationPrefix);
            }
            sb.append(resourcePathProp.toString());
            if (this.resourceExtension != null) {
                sb.append(this.resourceExtension);
            }
            return sb.toString();
        }
        return null;
    }

    private String getRequestPath() {
        Message inMessage = PhaseInterceptorChain.getCurrentMessage().getExchange().getInMessage();
        return (String)inMessage.get((Object)"org.apache.cxf.request.uri");
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setBeanNames(Map<String, String> beanNames) {
        this.beanNames = beanNames;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setLogRedirects(String value) {
        this.logRedirects = Boolean.valueOf(value);
    }

    protected String getBeanName(Object bean) {
        if (this.beanName != null) {
            return this.beanName;
        }
        String name = this.beanNames.get(bean.getClass().getName());
        if (name != null) {
            return name;
        }
        Class<?> resourceClass = bean.getClass();
        if (this.useClassNames && this.doGetClassResourceName(resourceClass) == null) {
            for (Class<?> cls : bean.getClass().getInterfaces()) {
                if (this.doGetClassResourceName(cls) == null) continue;
                resourceClass = cls;
                break;
            }
        }
        return resourceClass.getSimpleName().toLowerCase();
    }

    public void setResourcePaths(Map<String, String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public void setClassResources(Map<String, String> resources) {
        this.classResources = resources;
    }

    public void setEnumResources(Map<? extends Enum<?>, String> enumResources) {
        this.enumResources = enumResources;
    }

    public void setLocationPrefix(String locationPrefix) {
        this.locationPrefix = locationPrefix;
    }

    public void setResourceExtension(String resourceExtension) {
        this.resourceExtension = resourceExtension;
    }

    public void setErrorView(String errorView) {
        this.errorView = errorView;
    }
}

