/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxInInterceptor.class);
    private static Map<Object, XMLInputFactory> factories = new HashMap<Object, XMLInputFactory>();

    public StaxInInterceptor() {
        super("post-stream");
    }

    public StaxInInterceptor(String phase) {
        super(phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        XMLStreamReader reader;
        block13: {
            Map m;
            if (this.isGET(message) || message.getContent(XMLStreamReader.class) != null) {
                LOG.fine("StaxInInterceptor skipped.");
                return;
            }
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is == null) {
                return;
            }
            String contentType = (String)message.get((Object)"Content-Type");
            if (contentType != null && contentType.contains("text/html")) {
                String htmlMessage = null;
                try {
                    htmlMessage = IOUtils.toString((InputStream)is, (int)500);
                }
                catch (IOException e) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_HTML_RESPONSETYPE", LOG, new Object[]{"(none)"}));
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_HTML_RESPONSETYPE", LOG, new Object[]{htmlMessage == null || htmlMessage.length() == 0 ? "(none)" : htmlMessage}));
            }
            if (contentType == null && (m = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)))) != null) {
                List contentLen = HttpHeaderHelper.getHeader((Map)m, (String)"Content-Length");
                List contentTE = HttpHeaderHelper.getHeader((Map)m, (String)"Content-Transfer-Encoding");
                if ((StringUtils.isEmpty((List)contentLen) || "0".equals(contentLen.get(0))) && StringUtils.isEmpty((List)contentTE)) {
                    return;
                }
            }
            String encoding = (String)message.get((Object)Message.ENCODING);
            try {
                XMLInputFactory factory = StaxInInterceptor.getXMLInputFactory(message);
                if (factory == null) {
                    reader = StaxUtils.createXMLStreamReader((InputStream)is, (String)encoding);
                    break block13;
                }
                XMLInputFactory xMLInputFactory = factory;
                synchronized (xMLInputFactory) {
                    reader = factory.createXMLStreamReader(is, encoding);
                }
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STREAM_CREATE_EXC", LOG, new Object[]{encoding}), (Throwable)e);
            }
        }
        message.setContent(XMLStreamReader.class, (Object)reader);
        message.getInterceptorChain().add((Interceptor)StaxInEndingInterceptor.INSTANCE);
    }

    public static XMLInputFactory getXMLInputFactory(Message m) throws Fault {
        Object o = m.getContextualProperty(XMLInputFactory.class.getName());
        if (o instanceof XMLInputFactory) {
            return (XMLInputFactory)o;
        }
        if (o != null) {
            XMLInputFactory xif = factories.get(o);
            if (xif == null) {
                Class cls;
                if (o instanceof Class) {
                    cls = (Class)o;
                } else if (o instanceof String) {
                    try {
                        cls = ClassLoaderUtils.loadClass((String)((String)o), StaxInInterceptor.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_INPUT_FACTORY", LOG, new Object[]{o}));
                }
                try {
                    xif = (XMLInputFactory)cls.newInstance();
                    factories.put(o, xif);
                }
                catch (InstantiationException e) {
                    throw new Fault((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new Fault((Throwable)e);
                }
            }
            return xif;
        }
        return null;
    }
}

