/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

@NoJSR250Annotations
public class BusApplicationListener
implements ApplicationListener,
ApplicationContextAware {
    AbstractApplicationContext ctx;

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.ctx == null) {
            return;
        }
        boolean doIt = false;
        for (AbstractApplicationContext ac = this.ctx; ac != null && !doIt; ac = ac.getParent()) {
            if (event.getSource() != ac) continue;
            doIt = true;
        }
        if (doIt) {
            if (event instanceof ContextRefreshedEvent) {
                Bus bus = (Bus)this.ctx.getBean("cxf");
                ((CXFBusImpl)bus).initialize();
                BusLifeCycleManager lcm = (BusLifeCycleManager)this.ctx.getBean("org.apache.cxf.buslifecycle.BusLifeCycleManager", BusLifeCycleManager.class);
                lcm.initComplete();
            } else if (event instanceof ContextClosedEvent) {
                BusLifeCycleManager lcm = (BusLifeCycleManager)this.ctx.getBean("org.apache.cxf.buslifecycle.BusLifeCycleManager", BusLifeCycleManager.class);
                lcm.postShutdown();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof AbstractApplicationContext) {
            this.ctx = (AbstractApplicationContext)applicationContext;
            this.ctx.addApplicationListener((ApplicationListener)this);
        }
    }
}

