/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlUtilities {
    public static final String WSDL_TYPE = "wsdl";

    private WsdlUtilities() {
    }

    public static boolean fillWsdlOptionFromArtifact(GenericWsdlOption option, Artifact artifact, File outputDir) {
        if (!WSDL_TYPE.equals(artifact.getType())) {
            return false;
        }
        WsdlArtifact wsdlArtifact = new WsdlArtifact();
        wsdlArtifact.setArtifactId(artifact.getArtifactId());
        wsdlArtifact.setGroupId(artifact.getGroupId());
        wsdlArtifact.setType(artifact.getType());
        wsdlArtifact.setVersion(artifact.getVersion());
        option.setArtifact(wsdlArtifact);
        option.setOutputDir(outputDir);
        return true;
    }

    public static String joinWithComma(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (arr != null) {
            for (String s : arr) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s);
            }
        }
        return str.toString();
    }

    public static List<File> getWsdlFiles(File dir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList<String> exList = new ArrayList<String>();
        if (excludes != null) {
            exList.addAll(Arrays.asList(excludes));
        }
        exList.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        String inc = WsdlUtilities.joinWithComma(includes);
        String ex = WsdlUtilities.joinWithComma(exList.toArray(new String[exList.size()]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }
}

