/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import org.apache.crunch.PCollection;
import org.apache.hadoop.conf.Configuration;

public class PartitionUtils {
    public static final String BYTES_PER_REDUCE_TASK = "crunch.bytes.per.reduce.task";
    public static final long DEFAULT_BYTES_PER_REDUCE_TASK = 1000000000L;
    public static final String MAX_REDUCERS = "crunch.max.reducers";
    public static final int DEFAULT_MAX_REDUCERS = 500;

    public static <T> int getRecommendedPartitions(PCollection<T> pcollection) {
        Configuration conf = pcollection.getPipeline().getConfiguration();
        return PartitionUtils.getRecommendedPartitions(pcollection, conf);
    }

    public static <T> int getRecommendedPartitions(PCollection<T> pcollection, Configuration conf) {
        long bytesPerTask = conf.getLong(BYTES_PER_REDUCE_TASK, 1000000000L);
        int recommended = 1 + (int)(pcollection.getSize() / bytesPerTask);
        int maxRecommended = conf.getInt(MAX_REDUCERS, 500);
        if (maxRecommended > 0 && recommended > maxRecommended) {
            return maxRecommended;
        }
        return recommended;
    }
}

