/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class DistCache {
    private static final String TMPJARS_KEY = "tmpjars";

    public static void write(Configuration conf, Path path, Object value) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)path.getFileSystem(conf).create(path));
        oos.writeObject(value);
        oos.close();
        DistributedCache.addCacheFile((URI)path.toUri(), (Configuration)conf);
    }

    public static Object read(Configuration conf, Path path) throws IOException {
        URI target = null;
        for (URI uri : DistributedCache.getCacheFiles((Configuration)conf)) {
            if (!uri.toString().equals(path.toString())) continue;
            target = uri;
            break;
        }
        Object value = null;
        if (target != null) {
            Path targetPath = new Path(target.toString());
            ObjectInputStream ois = new ObjectInputStream((InputStream)targetPath.getFileSystem(conf).open(targetPath));
            try {
                value = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new CrunchRuntimeException(e);
            }
            ois.close();
        }
        return value;
    }

    public static void addCacheFile(Path path, Configuration conf) {
        DistributedCache.addCacheFile((URI)path.toUri(), (Configuration)conf);
    }

    public static Path getPathToCacheFile(Path path, Configuration conf) {
        try {
            for (Path localPath : DistributedCache.getLocalCacheFiles((Configuration)conf)) {
                if (!localPath.toString().endsWith(path.getName())) continue;
                return localPath.makeQualified((FileSystem)FileSystem.getLocal((Configuration)conf));
            }
        }
        catch (IOException e) {
            throw new CrunchRuntimeException(e);
        }
        return null;
    }

    public static void addJarToDistributedCache(Configuration conf, File jarFile) throws IOException {
        if (!jarFile.exists()) {
            throw new IOException("Jar file: " + jarFile.getCanonicalPath() + " does not exist.");
        }
        if (!jarFile.getName().endsWith(".jar")) {
            throw new IllegalArgumentException("File: " + jarFile.getCanonicalPath() + " is not a .jar " + "file.");
        }
        LocalFileSystem fileSystem = FileSystem.getLocal((Configuration)conf);
        Path jarPath = new Path(jarFile.getCanonicalPath());
        String qualifiedPath = jarPath.makeQualified((FileSystem)fileSystem).toString();
        String jarConfiguration = conf.get(TMPJARS_KEY, "");
        if (!jarConfiguration.isEmpty()) {
            jarConfiguration = jarConfiguration + ",";
        }
        jarConfiguration = jarConfiguration + qualifiedPath;
        conf.set(TMPJARS_KEY, jarConfiguration);
    }

    public static void addJarToDistributedCache(Configuration conf, String jarFile) throws IOException {
        DistCache.addJarToDistributedCache(conf, new File(jarFile));
    }

    public static String findContainingJar(Class<?> jarClass) throws IOException {
        ClassLoader loader = jarClass.getClassLoader();
        String classFile = jarClass.getName().replaceAll("\\.", "/") + ".class";
        Enumeration<URL> itr = loader.getResources(classFile);
        while (itr.hasMoreElements()) {
            URL url = itr.nextElement();
            if (!"jar".equals(url.getProtocol())) continue;
            String toReturn = url.getPath();
            if (toReturn.startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = toReturn.replaceAll("\\+", "%2B");
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        return null;
    }

    public static void addJarDirToDistributedCache(Configuration conf, File jarDirectory) throws IOException {
        if (!jarDirectory.exists() || !jarDirectory.isDirectory()) {
            throw new IOException("Jar directory: " + jarDirectory.getCanonicalPath() + " does not " + "exist or is not a directory.");
        }
        for (File file : jarDirectory.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            DistCache.addJarToDistributedCache(conf, file);
        }
    }

    public static void addJarDirToDistributedCache(Configuration conf, String jarDirectory) throws IOException {
        DistCache.addJarDirToDistributedCache(conf, new File(jarDirectory));
    }
}

