/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import java.io.Serializable;
import org.apache.crunch.PCollection;
import org.apache.crunch.PTable;
import org.apache.crunch.Pipeline;
import org.apache.crunch.PipelineExecution;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.Source;
import org.apache.crunch.TableSource;
import org.apache.crunch.Target;
import org.apache.crunch.impl.mem.MemPipeline;
import org.apache.crunch.impl.mr.MRPipeline;
import org.apache.crunch.io.At;
import org.apache.crunch.io.From;
import org.apache.crunch.io.To;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;

public abstract class CrunchTool
extends Configured
implements Tool,
Serializable {
    protected static final From from = new From();
    protected static final To to = new To();
    protected static final At at = new At();
    private transient Pipeline pipeline;

    public CrunchTool() {
        this(false);
    }

    public CrunchTool(boolean inMemory) {
        this.pipeline = inMemory ? MemPipeline.getInstance() : new MRPipeline(this.getClass());
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null && this.pipeline != null) {
            this.pipeline.setConfiguration(conf);
        }
    }

    public Configuration getConf() {
        return this.pipeline.getConfiguration();
    }

    public void enableDebug() {
        this.pipeline.enableDebug();
    }

    public <T> PCollection<T> read(Source<T> source) {
        return this.pipeline.read(source);
    }

    public <K, V> PTable<K, V> read(TableSource<K, V> tableSource) {
        return this.pipeline.read(tableSource);
    }

    public PCollection<String> readTextFile(String pathName) {
        return this.pipeline.readTextFile(pathName);
    }

    public void write(PCollection<?> pcollection, Target target) {
        this.pipeline.write(pcollection, target);
    }

    public void writeTextFile(PCollection<?> pcollection, String pathName) {
        this.pipeline.writeTextFile(pcollection, pathName);
    }

    public <T> Iterable<T> materialize(PCollection<T> pcollection) {
        return this.pipeline.materialize(pcollection);
    }

    public PipelineResult run() {
        return this.pipeline.run();
    }

    public PipelineExecution runAsync() {
        return this.pipeline.runAsync();
    }

    public PipelineResult done() {
        return this.pipeline.done();
    }

    protected Pipeline getPipeline() {
        return this.pipeline;
    }
}

