/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class TupleWritable
extends Configured
implements WritableComparable<TupleWritable> {
    private int[] written;
    private Writable[] values;

    public TupleWritable() {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        try {
            Writables.reloadWritableComparableCodes(conf);
        }
        catch (Exception e) {
            throw new CrunchRuntimeException("Error reloading writable comparable codes", e);
        }
    }

    private static int[] getCodes(Writable[] writables) {
        int[] b = new int[writables.length];
        for (int i = 0; i < b.length; ++i) {
            if (writables[i] == null) continue;
            b[i] = TupleWritable.getCode(writables[i].getClass());
        }
        return b;
    }

    public TupleWritable(Writable[] values) {
        this(values, TupleWritable.getCodes(values));
    }

    public TupleWritable(Writable[] values, int[] written) {
        Preconditions.checkArgument((values.length == written.length ? 1 : 0) != 0);
        this.written = written;
        this.values = values;
    }

    public boolean has(int i) {
        return this.written[i] != 0;
    }

    public Writable get(int i) {
        return this.values[i];
    }

    public int size() {
        return this.values.length;
    }

    public boolean equals(Object other) {
        if (other instanceof TupleWritable) {
            TupleWritable that = (TupleWritable)((Object)other);
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.has(i) || this.written[i] == that.written[i] && this.values[i].equals(that.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.written);
        for (Writable v : this.values) {
            builder.append((Object)v);
        }
        return builder.toHashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < this.values.length; ++i) {
            if (this.has(i)) {
                buf.append(this.values[i].toString());
            }
            buf.append(",");
        }
        if (this.values.length != 0) {
            buf.setCharAt(buf.length() - 1, ']');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    public void clear() {
        Arrays.fill(this.written, 0);
    }

    public void set(int index, Writable w) {
        this.written[index] = TupleWritable.getCode(w.getClass());
        this.values[index] = w;
    }

    public void write(DataOutput out) throws IOException {
        DataOutputBuffer tmp = new DataOutputBuffer();
        WritableUtils.writeVInt((DataOutput)out, (int)this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.written[i]);
            if (this.written[i] == 0) continue;
            tmp.reset();
            this.values[i].write((DataOutput)tmp);
            WritableUtils.writeVInt((DataOutput)out, (int)tmp.getLength());
            out.write(tmp.getData(), 0, tmp.getLength());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int card = WritableUtils.readVInt((DataInput)in);
        this.values = new Writable[card];
        this.written = new int[card];
        for (int i = 0; i < card; ++i) {
            this.written[i] = WritableUtils.readVInt((DataInput)in);
            if (this.written[i] == 0) continue;
            this.values[i] = TupleWritable.getWritable(this.written[i], this.getConf());
            WritableUtils.readVInt((DataInput)in);
            this.values[i].readFields(in);
        }
    }

    static int getCode(Class<? extends Writable> clazz) {
        if (Writables.WRITABLE_CODES.inverse().containsKey(clazz)) {
            return (Integer)Writables.WRITABLE_CODES.inverse().get(clazz);
        }
        return 1;
    }

    static Writable getWritable(int code, Configuration conf) {
        Class clazz = (Class)Writables.WRITABLE_CODES.get((Object)code);
        if (clazz != null) {
            return WritableFactories.newInstance((Class)clazz, (Configuration)conf);
        }
        throw new IllegalStateException("Unknown Writable code: " + code);
    }

    public int compareTo(TupleWritable that) {
        for (int i = 0; i < Math.min(this.size(), that.size()); ++i) {
            if (!this.has(i) && !that.has(i)) continue;
            if (this.has(i) && !that.has(i)) {
                return 1;
            }
            if (!this.has(i) && that.has(i)) {
                return -1;
            }
            if (this.written[i] != that.written[i]) {
                return this.written[i] - that.written[i];
            }
            Writable v1 = this.values[i];
            Writable v2 = that.values[i];
            int cmp = v1 instanceof WritableComparable && v2 instanceof WritableComparable ? ((WritableComparable)v1).compareTo((Object)v2) : v1.hashCode() - v2.hashCode();
            if (cmp == 0) continue;
            return cmp;
        }
        return this.size() - that.size();
    }

    static {
        WritableComparator.define(TupleWritable.class, (WritableComparator)Comparator.getInstance());
    }

    public static class Comparator
    extends WritableComparator {
        private static final Comparator INSTANCE = new Comparator();

        public static Comparator getInstance() {
            return INSTANCE;
        }

        private Comparator() {
            super(TupleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            try {
                buffer1.reset(b1, s1, l1);
                buffer2.reset(b2, s2, l2);
                int card1 = WritableUtils.readVInt((DataInput)buffer1);
                int card2 = WritableUtils.readVInt((DataInput)buffer2);
                int minCard = Math.min(card1, card2);
                for (int i = 0; i < minCard; ++i) {
                    int cmp = this.compareField(buffer1, buffer2);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return card1 - card2;
            }
            catch (IOException e) {
                throw new CrunchRuntimeException(e);
            }
        }

        private int compareField(DataInputBuffer buffer1, DataInputBuffer buffer2) throws IOException {
            boolean hasValue2;
            int written1 = WritableUtils.readVInt((DataInput)buffer1);
            int written2 = WritableUtils.readVInt((DataInput)buffer2);
            boolean hasValue1 = written1 != 0;
            boolean bl = hasValue2 = written2 != 0;
            if (!hasValue1 && !hasValue2) {
                return 0;
            }
            if (hasValue1 && !hasValue2) {
                return 1;
            }
            if (!hasValue1 && hasValue2) {
                return -1;
            }
            if (written1 != written2) {
                return written1 - written2;
            }
            int bodySize1 = WritableUtils.readVInt((DataInput)buffer1);
            int bodySize2 = WritableUtils.readVInt((DataInput)buffer2);
            Class clazz = (Class)Writables.WRITABLE_CODES.get((Object)written1);
            if (WritableComparable.class.isAssignableFrom(clazz)) {
                int cmp = WritableComparator.get(clazz.asSubclass(WritableComparable.class)).compare(buffer1.getData(), buffer1.getPosition(), bodySize1, buffer2.getData(), buffer2.getPosition(), bodySize2);
                buffer1.skip((long)bodySize1);
                buffer2.skip((long)bodySize2);
                return cmp;
            }
            Writable w1 = (Writable)ReflectionUtils.newInstance((Class)clazz, null);
            Writable w2 = (Writable)ReflectionUtils.newInstance((Class)clazz, null);
            w1.readFields((DataInput)buffer1);
            w2.readFields((DataInput)buffer2);
            return w1.hashCode() - w2.hashCode();
        }

        public int compare(WritableComparable a, WritableComparable b) {
            return super.compare(a, b);
        }
    }
}

