/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

class TextMapWritable
implements Writable {
    private final Map<Text, BytesWritable> instance = Maps.newHashMap();

    public void put(Text txt, BytesWritable value) {
        this.instance.put(txt, value);
    }

    public Set<Map.Entry<Text, BytesWritable>> entrySet() {
        return this.instance.entrySet();
    }

    public void readFields(DataInput in) throws IOException {
        this.instance.clear();
        int entries = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < entries; ++i) {
            Text txt = new Text();
            txt.readFields(in);
            BytesWritable value = new BytesWritable();
            value.readFields(in);
            this.instance.put(txt, value);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.instance.size());
        for (Map.Entry<Text, BytesWritable> e : this.instance.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
    }
}

