/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

class GenericArrayWritable
implements Writable {
    private BytesWritable[] values;
    private Class<? extends Writable> valueClass;

    public GenericArrayWritable(Class<? extends Writable> valueClass) {
        this.valueClass = valueClass;
    }

    public GenericArrayWritable() {
    }

    public void set(BytesWritable[] values) {
        this.values = values;
    }

    public BytesWritable[] get() {
        return this.values;
    }

    public void readFields(DataInput in) throws IOException {
        this.values = new BytesWritable[WritableUtils.readVInt((DataInput)in)];
        if (this.values.length > 0) {
            int nulls = WritableUtils.readVInt((DataInput)in);
            if (nulls == this.values.length) {
                return;
            }
            for (int i = 0; i < this.values.length - nulls; ++i) {
                BytesWritable value = new BytesWritable();
                value.readFields(in);
                this.values[i] = value;
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.values.length);
        if (this.values.length > 0) {
            int i;
            int nulls = 0;
            for (i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) continue;
                ++nulls;
            }
            WritableUtils.writeVInt((DataOutput)out, (int)nulls);
            if (this.values.length - nulls > 0) {
                for (i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.values[i].write(out);
                }
            }
        }
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append((Object[])this.values).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericArrayWritable other = (GenericArrayWritable)obj;
        return Arrays.equals(this.values, other.values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

