/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.io.IOException;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class AvroUtf8InputFormat
extends FileInputFormat<AvroWrapper<Utf8>, NullWritable> {
    private CompressionCodecFactory compressionCodecs = null;

    public void configure(Configuration conf) {
        this.compressionCodecs = new CompressionCodecFactory(conf);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        return this.compressionCodecs.getCodec(file) == null;
    }

    public RecordReader<AvroWrapper<Utf8>, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new Utf8LineRecordReader();
    }

    static class Utf8LineRecordReader
    extends RecordReader<AvroWrapper<Utf8>, NullWritable> {
        private LineRecordReader lineRecordReader;
        private AvroWrapper<Utf8> currentKey = new AvroWrapper();

        public Utf8LineRecordReader() throws IOException {
            this.lineRecordReader = new LineRecordReader();
        }

        public void close() throws IOException {
            this.lineRecordReader.close();
        }

        public float getProgress() throws IOException {
            return this.lineRecordReader.getProgress();
        }

        public AvroWrapper<Utf8> getCurrentKey() throws IOException, InterruptedException {
            Text txt = this.lineRecordReader.getCurrentValue();
            this.currentKey.datum((Object)new Utf8(txt.toString()));
            return this.currentKey;
        }

        public NullWritable getCurrentValue() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordReader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.lineRecordReader.nextKeyValue();
        }
    }
}

