/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.TupleDeepCopier;
import org.apache.crunch.types.avro.AvroGroupedTableType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.BaseAvroTableType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

class AvroTableType<K, V>
extends BaseAvroTableType<K, V>
implements PTableType<K, V> {
    private final AvroType<K> keyType;
    private final AvroType<V> valueType;

    public AvroTableType(AvroType<K> keyType, AvroType<V> valueType, Class<Pair<K, V>> pairClass) {
        super(pairClass, org.apache.avro.mapred.Pair.getPairSchema((Schema)keyType.getSchema(), (Schema)AvroTableType.nullable(valueType.getSchema())), (MapFn)new IndexedRecordToPair(keyType.getInputMapFn(), valueType.getInputMapFn()), (MapFn)new PairToAvroPair(keyType, valueType), new TupleDeepCopier(Pair.class, keyType, valueType), (AvroType.AvroRecordType)null, new PType[]{keyType, valueType});
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public PType<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public PGroupedTableType<K, V> getGroupedTableType() {
        return new AvroGroupedTableType(this);
    }

    @Override
    public Pair<K, V> getDetachedValue(Pair<K, V> value) {
        return PTables.getDetachedValue(this, value);
    }

    private static Schema nullable(Schema schema) {
        if (schema.getType() == Schema.Type.NULL) {
            return schema;
        }
        return Schema.createUnion((List)ImmutableList.of((Object)schema, (Object)Schema.create((Schema.Type)Schema.Type.NULL)));
    }

    private static class IndexedRecordToPair
    extends MapFn<IndexedRecord, Pair> {
        private final MapFn firstMapFn;
        private final MapFn secondMapFn;

        public IndexedRecordToPair(MapFn firstMapFn, MapFn secondMapFn) {
            this.firstMapFn = firstMapFn;
            this.secondMapFn = secondMapFn;
        }

        @Override
        public void configure(Configuration conf) {
            this.firstMapFn.configure(conf);
            this.secondMapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.firstMapFn.setContext(context);
            this.secondMapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.firstMapFn.initialize();
            this.secondMapFn.initialize();
        }

        @Override
        public Pair map(IndexedRecord input) {
            return Pair.of(this.firstMapFn.map(input.get(0)), this.secondMapFn.map(input.get(1)));
        }
    }

    private static class PairToAvroPair
    extends MapFn<Pair, org.apache.avro.mapred.Pair> {
        private final MapFn keyMapFn;
        private final MapFn valueMapFn;
        private final String firstJson;
        private final String secondJson;
        private String pairSchemaJson;
        private transient Schema pairSchema;

        public PairToAvroPair(AvroType keyType, AvroType valueType) {
            this.keyMapFn = keyType.getOutputMapFn();
            this.firstJson = keyType.getSchema().toString();
            this.valueMapFn = valueType.getOutputMapFn();
            this.secondJson = valueType.getSchema().toString();
        }

        @Override
        public void configure(Configuration conf) {
            this.keyMapFn.configure(conf);
            this.valueMapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.keyMapFn.setContext(context);
            this.valueMapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.keyMapFn.initialize();
            this.valueMapFn.initialize();
            this.pairSchemaJson = org.apache.avro.mapred.Pair.getPairSchema((Schema)new Schema.Parser().parse(this.firstJson), (Schema)AvroTableType.nullable(new Schema.Parser().parse(this.secondJson))).toString();
        }

        @Override
        public org.apache.avro.mapred.Pair map(Pair input) {
            if (this.pairSchema == null) {
                this.pairSchema = new Schema.Parser().parse(this.pairSchemaJson);
            }
            org.apache.avro.mapred.Pair avroPair = new org.apache.avro.mapred.Pair(this.pairSchema);
            avroPair.key(this.keyMapFn.map(input.first()));
            avroPair.value(this.valueMapFn.map(input.second()));
            return avroPair;
        }
    }
}

