/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.io.IOException;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.util.Utf8;
import org.apache.crunch.types.avro.AvroOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class AvroPathPerKeyOutputFormat<T>
extends FileOutputFormat<AvroWrapper<Pair<Utf8, T>>, NullWritable> {
    public RecordWriter<AvroWrapper<Pair<Utf8, T>>, NullWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = taskAttemptContext.getConfiguration();
        Path basePath = new Path(AvroPathPerKeyOutputFormat.getOutputPath((JobContext)taskAttemptContext), conf.get("mapreduce.output.basename", "part"));
        return new AvroFilePerKeyRecordWriter(basePath, AvroPathPerKeyOutputFormat.getUniqueFile((TaskAttemptContext)taskAttemptContext, (String)"part", (String)".avro"), conf);
    }

    private class AvroFilePerKeyRecordWriter<T>
    extends RecordWriter<AvroWrapper<Pair<Utf8, T>>, NullWritable> {
        private final Path basePath;
        private final String uniqueFileName;
        private final Configuration conf;
        private String currentKey;
        private DataFileWriter<T> currentWriter;

        public AvroFilePerKeyRecordWriter(Path basePath, String uniqueFileName, Configuration conf) {
            this.basePath = basePath;
            this.uniqueFileName = uniqueFileName;
            this.conf = conf;
        }

        public void write(AvroWrapper<Pair<Utf8, T>> record, NullWritable n) throws IOException, InterruptedException {
            String key = ((Utf8)((Pair)record.datum()).key()).toString();
            if (!key.equals(this.currentKey)) {
                if (this.currentWriter != null) {
                    this.currentWriter.close();
                }
                this.currentKey = key;
                Path dir = new Path(this.basePath, key);
                FileSystem fs = dir.getFileSystem(this.conf);
                if (!fs.exists(dir)) {
                    fs.mkdirs(dir);
                }
                this.currentWriter = AvroOutputFormat.getDataFileWriter(new Path(dir, this.uniqueFileName), this.conf);
            }
            this.currentWriter.append(((Pair)record.datum()).value());
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            if (this.currentWriter != null) {
                this.currentWriter.close();
                this.currentKey = null;
                this.currentWriter = null;
            }
        }
    }
}

