/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.util.Iterator;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.crunch.Pair;
import org.apache.crunch.types.Converter;

class AvroPairConverter<K, V>
implements Converter<AvroKey<K>, AvroValue<V>, Pair<K, V>, Pair<K, Iterable<V>>> {
    private transient AvroKey<K> keyWrapper = null;
    private transient AvroValue<V> valueWrapper = null;

    AvroPairConverter() {
    }

    @Override
    public Pair<K, V> convertInput(AvroKey<K> key, AvroValue<V> value) {
        return Pair.of(key.datum(), value.datum());
    }

    @Override
    public Pair<K, Iterable<V>> convertIterableInput(AvroKey<K> key, Iterable<AvroValue<V>> iter) {
        AvroWrappedIterable<V> it = new AvroWrappedIterable<V>(iter);
        return Pair.of(key.datum(), it);
    }

    @Override
    public AvroKey<K> outputKey(Pair<K, V> value) {
        this.getKeyWrapper().datum(value.first());
        return this.keyWrapper;
    }

    @Override
    public AvroValue<V> outputValue(Pair<K, V> value) {
        this.getValueWrapper().datum(value.second());
        return this.valueWrapper;
    }

    @Override
    public Class<AvroKey<K>> getKeyClass() {
        return this.getKeyWrapper().getClass();
    }

    @Override
    public Class<AvroValue<V>> getValueClass() {
        return this.getValueWrapper().getClass();
    }

    @Override
    public boolean applyPTypeTransforms() {
        return true;
    }

    private AvroKey<K> getKeyWrapper() {
        if (this.keyWrapper == null) {
            this.keyWrapper = new AvroKey();
        }
        return this.keyWrapper;
    }

    private AvroValue<V> getValueWrapper() {
        if (this.valueWrapper == null) {
            this.valueWrapper = new AvroValue();
        }
        return this.valueWrapper;
    }

    private static class AvroWrappedIterable<V>
    implements Iterable<V> {
        private final Iterable<AvroValue<V>> iters;

        public AvroWrappedIterable(Iterable<AvroValue<V>> iters) {
            this.iters = iters;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private final Iterator<AvroValue<V>> it;
                {
                    this.it = AvroWrappedIterable.this.iters.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public V next() {
                    return this.it.next().datum();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }
}

