/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.crunch.types.avro.ReaderWriterFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;

public class AvroMode
implements ReaderWriterFactory {
    public static final AvroMode REFLECT = new AvroMode(ModeType.REFLECT, "crunch.reflectdatafactory");
    public static final AvroMode SPECIFIC = new AvroMode(ModeType.SPECIFIC, "crunch.specificfactory");
    public static final AvroMode GENERIC = new AvroMode(ModeType.GENERIC, "crunch.genericfactory");
    public static final String AVRO_MODE_PROPERTY = "crunch.avro.mode";
    public static final String AVRO_SHUFFLE_MODE_PROPERTY = "crunch.avro.shuffle.mode";
    private static ClassLoader specificLoader = null;
    private final ReaderWriterFactory factory;
    private final String propName;
    private final ModeType modeType;

    public static AvroMode fromConfiguration(Configuration conf) {
        AvroMode mode = AvroMode.getMode((ModeType)conf.getEnum(AVRO_MODE_PROPERTY, (Enum)ModeType.REFLECT));
        return mode.withFactoryFromConfiguration(conf);
    }

    public static AvroMode fromShuffleConfiguration(Configuration conf) {
        AvroMode mode = AvroMode.getMode((ModeType)conf.getEnum(AVRO_SHUFFLE_MODE_PROPERTY, (Enum)ModeType.REFLECT));
        return mode.withFactoryFromConfiguration(conf);
    }

    public static AvroMode fromType(AvroType<?> type) {
        if (type.hasReflect()) {
            if (type.hasSpecific()) {
                Avros.checkCombiningSpecificAndReflectionSchemas();
            }
            return REFLECT;
        }
        if (type.hasSpecific()) {
            return SPECIFIC;
        }
        return GENERIC;
    }

    private static AvroMode getMode(ModeType modeType) {
        switch (modeType) {
            case SPECIFIC: {
                return SPECIFIC;
            }
            case GENERIC: {
                return GENERIC;
            }
        }
        return REFLECT;
    }

    public static void setSpecificClassLoader(ClassLoader loader) {
        specificLoader = loader;
    }

    public static ClassLoader getSpecificClassLoader() {
        return specificLoader;
    }

    static void registerSpecificClassLoaderInternal(ClassLoader loader) {
        if (specificLoader == null) {
            AvroMode.setSpecificClassLoader(loader);
        }
    }

    private AvroMode(ModeType modeType, ReaderWriterFactory factory, String propName) {
        this.factory = factory;
        this.propName = propName;
        this.modeType = modeType;
    }

    private AvroMode(ModeType modeType, String propName) {
        this(modeType, null, propName);
    }

    @Override
    public GenericData getData() {
        if (this.factory != null) {
            return this.factory.getData();
        }
        switch (this.modeType) {
            case REFLECT: {
                return ReflectData.AllowNull.get();
            }
            case SPECIFIC: {
                return SpecificData.get();
            }
        }
        return GenericData.get();
    }

    public <T> DatumReader<T> getReader(Schema schema) {
        if (this.factory != null) {
            return this.factory.getReader(schema);
        }
        switch (this.modeType) {
            case REFLECT: {
                if (specificLoader != null) {
                    return new ReflectDatumReader(schema, schema, new ReflectData(specificLoader));
                }
                return new ReflectDatumReader(schema);
            }
            case SPECIFIC: {
                if (specificLoader != null) {
                    return new SpecificDatumReader(schema, schema, new SpecificData(specificLoader));
                }
                return new SpecificDatumReader(schema);
            }
        }
        return new GenericDatumReader(schema);
    }

    public <T> DatumWriter<T> getWriter(Schema schema) {
        if (this.factory != null) {
            return this.factory.getWriter(schema);
        }
        switch (this.modeType) {
            case REFLECT: {
                return new ReflectDatumWriter(schema);
            }
            case SPECIFIC: {
                return new SpecificDatumWriter(schema);
            }
        }
        return new GenericDatumWriter(schema);
    }

    @Deprecated
    public AvroMode override(ReaderWriterFactory factory) {
        return this.withFactory(factory);
    }

    public AvroMode withFactory(ReaderWriterFactory factory) {
        if (factory != this) {
            return this.withReaderWriterFactory(factory);
        }
        return this;
    }

    public void configureShuffle(Configuration conf) {
        conf.setEnum(AVRO_SHUFFLE_MODE_PROPERTY, (Enum)this.modeType);
        this.configure(conf);
    }

    public void configure(FormatBundle bundle) {
        bundle.set(AVRO_MODE_PROPERTY, this.modeType.toString());
        if (this.factory != null) {
            bundle.set(this.propName, this.factory.getClass().getName());
        }
    }

    public void configure(Configuration conf) {
        conf.set(AVRO_MODE_PROPERTY, this.modeType.toString());
        if (this.factory != null) {
            conf.setClass(this.propName, this.factory.getClass(), ReaderWriterFactory.class);
        }
    }

    public Map<String, String> getModeProperties() {
        HashMap props = Maps.newHashMap();
        props.put(AVRO_MODE_PROPERTY, this.modeType.toString());
        if (this.factory != null) {
            props.put(this.propName, this.factory.getClass().getCanonicalName());
        }
        return props;
    }

    @Deprecated
    public void configureFactory(Configuration conf) {
        this.configure(conf);
    }

    private AvroMode withReaderWriterFactory(ReaderWriterFactory readerWriterFactory) {
        return new AvroMode(this.modeType, readerWriterFactory, this.propName);
    }

    public ReaderWriterFactory getFactory() {
        return this.factory != null ? this.factory : this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvroMode)) {
            return false;
        }
        AvroMode that = (AvroMode)o;
        if (!this.modeType.equals((Object)that.modeType)) {
            return false;
        }
        if (!this.propName.equals(that.propName)) {
            return false;
        }
        if (this.factory != null) {
            if (that.factory == null) {
                return false;
            }
            return this.factory.equals(that.factory);
        }
        return that.factory == null;
    }

    public int hashCode() {
        int hash = this.propName.hashCode();
        hash = 31 * hash + this.modeType.hashCode();
        if (this.factory != null) {
            hash = 31 * hash + this.factory.hashCode();
        }
        return hash;
    }

    public AvroMode withFactoryFromConfiguration(Configuration conf) {
        Class factoryClass = conf.getClass(this.propName, this.getClass());
        if (factoryClass != this.getClass()) {
            return this.withReaderWriterFactory((ReaderWriterFactory)ReflectionUtils.newInstance((Class)factoryClass, (Configuration)conf));
        }
        return this;
    }

    public static enum ModeType {
        SPECIFIC,
        REFLECT,
        GENERIC;

    }
}

