/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.TupleDeepCopier;
import org.apache.crunch.types.avro.AvroGroupedTableType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.BaseAvroTableType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

class AvroKeyValueTableType<K, V>
extends BaseAvroTableType<K, V>
implements PTableType<K, V> {
    private final AvroType<K> keyType;
    private final AvroType<V> valueType;

    public AvroKeyValueTableType(AvroType<K> keyType, AvroType<V> valueType, Class<Pair<K, V>> pairClass) {
        super(pairClass, AvroKeyValue.getSchema((Schema)keyType.getSchema(), (Schema)valueType.getSchema()), (MapFn)new AvroKeyValueRecordToPair(keyType.getInputMapFn(), valueType.getInputMapFn()), (MapFn)new PairToAvroKeyValueRecord(keyType, valueType), new TupleDeepCopier(Pair.class, keyType, valueType), (AvroType.AvroRecordType)null, new PType[]{keyType, valueType});
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public PType<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public PGroupedTableType<K, V> getGroupedTableType() {
        return new AvroGroupedTableType(this);
    }

    @Override
    public Pair<K, V> getDetachedValue(Pair<K, V> value) {
        return PTables.getDetachedValue(this, value);
    }

    private static class AvroKeyValueRecordToPair
    extends MapFn<GenericRecord, Pair> {
        private final MapFn firstMapFn;
        private final MapFn secondMapFn;

        public AvroKeyValueRecordToPair(MapFn firstMapFn, MapFn secondMapFn) {
            this.firstMapFn = firstMapFn;
            this.secondMapFn = secondMapFn;
        }

        @Override
        public void configure(Configuration conf) {
            this.firstMapFn.configure(conf);
            this.secondMapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.firstMapFn.setContext(context);
            this.secondMapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.firstMapFn.initialize();
            this.secondMapFn.initialize();
        }

        @Override
        public Pair map(GenericRecord input) {
            return Pair.of(this.firstMapFn.map(input.get("key")), this.secondMapFn.map(input.get("value")));
        }
    }

    private static class PairToAvroKeyValueRecord
    extends MapFn<Pair, GenericRecord> {
        private final MapFn keyMapFn;
        private final MapFn valueMapFn;
        private final String keySchemaJson;
        private final String valueSchemaJson;
        private String keyValueSchemaJson;
        private transient Schema keyValueSchema;

        public PairToAvroKeyValueRecord(AvroType keyType, AvroType valueType) {
            this.keyMapFn = keyType.getOutputMapFn();
            this.keySchemaJson = keyType.getSchema().toString();
            this.valueMapFn = valueType.getOutputMapFn();
            this.valueSchemaJson = valueType.getSchema().toString();
        }

        @Override
        public void configure(Configuration conf) {
            this.keyMapFn.configure(conf);
            this.valueMapFn.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.keyMapFn.setContext(context);
            this.valueMapFn.setContext(context);
        }

        @Override
        public void initialize() {
            this.keyMapFn.initialize();
            this.valueMapFn.initialize();
            Schema.Parser parser = new Schema.Parser();
            this.keyValueSchemaJson = AvroKeyValue.getSchema((Schema)parser.parse(this.keySchemaJson), (Schema)parser.parse(this.valueSchemaJson)).toString();
        }

        @Override
        public GenericRecord map(Pair input) {
            if (this.keyValueSchema == null) {
                this.keyValueSchema = new Schema.Parser().parse(this.keyValueSchemaJson);
            }
            GenericData.Record keyValueRecord = new GenericData.Record(this.keyValueSchema);
            keyValueRecord.put("key", this.keyMapFn.map(input.first()));
            keyValueRecord.put("value", this.valueMapFn.map(input.second()));
            return keyValueRecord;
        }
    }
}

