/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.util.Collection;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroKeyComparator;
import org.apache.avro.mapred.AvroValue;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.fn.PairMapFn;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroPairConverter;
import org.apache.crunch.types.avro.AvroTableType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.crunch.types.avro.BaseAvroTableType;
import org.apache.crunch.types.avro.SafeAvroSerialization;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

class AvroGroupedTableType<K, V>
extends PGroupedTableType<K, V> {
    private static final AvroPairConverter CONVERTER = new AvroPairConverter();
    private final MapFn inputFn;
    private final MapFn outputFn;

    public AvroGroupedTableType(BaseAvroTableType<K, V> tableType) {
        super(tableType);
        AvroType keyType = (AvroType)tableType.getKeyType();
        AvroType valueType = (AvroType)tableType.getValueType();
        this.inputFn = new PGroupedTableType.PairIterableMapFn(keyType.getInputMapFn(), valueType.getInputMapFn());
        this.outputFn = new PairMapFn(keyType.getOutputMapFn(), valueType.getOutputMapFn());
    }

    @Override
    public Class<Pair<K, Iterable<V>>> getTypeClass() {
        return Pair.of(null, null).getClass();
    }

    @Override
    public Converter getGroupingConverter() {
        return CONVERTER;
    }

    @Override
    public MapFn getInputMapFn() {
        return this.inputFn;
    }

    @Override
    public MapFn getOutputMapFn() {
        return this.outputFn;
    }

    @Override
    public void initialize(Configuration conf) {
        this.getTableType().initialize(conf);
    }

    @Override
    public Pair<K, Iterable<V>> getDetachedValue(Pair<K, Iterable<V>> value) {
        return PTables.getGroupedDetachedValue(this, value);
    }

    @Override
    public void configureShuffle(Job job, GroupingOptions options) {
        AvroTableType att = (AvroTableType)this.tableType;
        String schemaJson = att.getSchema().toString();
        Configuration conf = job.getConfiguration();
        if (att.hasReflect()) {
            if (att.hasSpecific()) {
                Avros.checkCombiningSpecificAndReflectionSchemas();
            }
            conf.setBoolean("avro.map.output.is.reflect", true);
        }
        conf.set("avro.map.output.schema", schemaJson);
        job.setSortComparatorClass(AvroKeyComparator.class);
        job.setMapOutputKeyClass(AvroKey.class);
        job.setMapOutputValueClass(AvroValue.class);
        if (options != null) {
            options.configure(job);
        }
        AvroMode.fromType(att).withFactoryFromConfiguration(conf).configureShuffle(conf);
        Collection serializations = job.getConfiguration().getStringCollection("io.serializations");
        if (!serializations.contains(SafeAvroSerialization.class.getName())) {
            serializations.add(SafeAvroSerialization.class.getName());
            job.getConfiguration().setStrings("io.serializations", serializations.toArray(new String[0]));
        }
    }
}

