/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.hadoop.conf.Configuration;

abstract class AvroDeepCopier<T>
implements DeepCopier<T>,
Serializable {
    private String jsonSchema;
    protected transient Configuration conf;
    private transient Schema schema;

    public AvroDeepCopier(Schema schema) {
        this.jsonSchema = schema.toString();
    }

    protected Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema.Parser().parse(this.jsonSchema);
        }
        return this.schema;
    }

    @Override
    public void initialize(Configuration conf) {
        this.conf = conf;
    }

    public static class AvroByteBufferDeepCopier
    implements DeepCopier<ByteBuffer> {
        public static final AvroByteBufferDeepCopier INSTANCE = new AvroByteBufferDeepCopier();

        @Override
        public void initialize(Configuration conf) {
        }

        @Override
        public ByteBuffer deepCopy(ByteBuffer source) {
            if (source == null) {
                return null;
            }
            byte[] copy = new byte[source.limit()];
            System.arraycopy(source.array(), 0, copy, 0, source.limit());
            return ByteBuffer.wrap(copy);
        }
    }

    public static class AvroReflectDeepCopier<T>
    extends AvroDeepCopier<T> {
        private DatumReader<T> datumReader;
        private DatumWriter<T> datumWriter;
        private BinaryEncoder binaryEncoder;
        private BinaryDecoder binaryDecoder;
        private final Class<T> valueClass;

        public AvroReflectDeepCopier(Class<T> valueClass, Schema schema) {
            super(schema);
            this.valueClass = valueClass;
        }

        protected DatumReader<T> createDatumReader(Configuration conf) {
            return AvroMode.REFLECT.withFactoryFromConfiguration(conf).getReader(this.getSchema());
        }

        protected DatumWriter<T> createDatumWriter(Configuration conf) {
            return AvroMode.REFLECT.withFactoryFromConfiguration(conf).getWriter(this.getSchema());
        }

        @Override
        public T deepCopy(T source) {
            if (source == null) {
                return null;
            }
            if (this.datumReader == null) {
                this.datumReader = this.createDatumReader(this.conf);
            }
            if (this.datumWriter == null) {
                this.datumWriter = this.createDatumWriter(this.conf);
            }
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            this.binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)byteOutStream, this.binaryEncoder);
            T target = this.createNewInstance(this.valueClass);
            try {
                this.datumWriter.write(source, (Encoder)this.binaryEncoder);
                this.binaryEncoder.flush();
                this.binaryDecoder = DecoderFactory.get().binaryDecoder(byteOutStream.toByteArray(), this.binaryDecoder);
                return (T)this.datumReader.read(target, (Decoder)this.binaryDecoder);
            }
            catch (Exception e) {
                throw new CrunchRuntimeException("Error while deep copying avro value " + source, e);
            }
        }

        protected T createNewInstance(Class<T> targetClass) {
            try {
                return targetClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new CrunchRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new CrunchRuntimeException(e);
            }
        }
    }

    public static class AvroGenericDeepCopier
    extends AvroDeepCopier<GenericData.Record> {
        public AvroGenericDeepCopier(Schema schema) {
            super(schema);
        }

        @Override
        public GenericData.Record deepCopy(GenericData.Record source) {
            return (GenericData.Record)GenericData.get().deepCopy(this.getSchema(), (Object)source);
        }
    }

    public static class AvroSpecificDeepCopier<T>
    extends AvroDeepCopier<T> {
        public AvroSpecificDeepCopier(Schema schema) {
            super(schema);
        }

        @Override
        public T deepCopy(T source) {
            return (T)SpecificData.get().deepCopy(this.getSchema(), source);
        }
    }
}

