/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;

class AvroCapabilities {
    AvroCapabilities() {
    }

    static boolean canDecodeSpecificSchemaWithReflectDatumReader() {
        ReflectDatumReader datumReader = new ReflectDatumReader(Record.SCHEMA$);
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(Record.SCHEMA$);
        Record record = new Record();
        record.subrecords = Lists.newArrayList((Object[])new CharSequence[]{"a", "b"});
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        try {
            datumWriter.write((Object)record, (Encoder)encoder);
            encoder.flush();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(byteArrayOutputStream.toByteArray(), null);
            datumReader.read((Object)record, (Decoder)decoder);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error performing specific schema test", ioe);
        }
        catch (ClassCastException cce) {
            return false;
        }
        return true;
    }

    public static class Record
    extends SpecificRecordBase
    implements SpecificRecord {
        public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Record\",\"namespace\":\"org.apache.crunch.types.avro\",\"fields\":[{\"name\":\"subrecords\",\"type\":{\"type\":\"array\",\"items\":\"string\"}}]}");
        @Deprecated
        public List<CharSequence> subrecords;

        public Object get(int field$) {
            switch (field$) {
                case 0: {
                    return this.subrecords;
                }
            }
            throw new AvroRuntimeException("Bad index");
        }

        public void put(int field$, Object value$) {
            switch (field$) {
                case 0: {
                    this.subrecords = (List)value$;
                    break;
                }
                default: {
                    throw new AvroRuntimeException("Bad index");
                }
            }
        }

        public Schema getSchema() {
            return SCHEMA$;
        }
    }
}

