/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.crunch.Union;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;

public class UnionDeepCopier
implements DeepCopier<Union> {
    private final List<PType> elementTypes;

    public UnionDeepCopier(PType ... elementTypes) {
        this.elementTypes = Lists.newArrayList((Object[])elementTypes);
    }

    @Override
    public void initialize(Configuration conf) {
        for (PType elementType : this.elementTypes) {
            elementType.initialize(conf);
        }
    }

    @Override
    public Union deepCopy(Union source) {
        if (source == null) {
            return null;
        }
        int index = source.getIndex();
        Object copy = this.elementTypes.get(index).getDetachedValue(source.getValue());
        return new Union(index, copy);
    }
}

