/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;

public abstract class TupleFactory<T extends Tuple>
implements Serializable {
    private static final Map<Class, TupleFactory> customTupleFactories = Maps.newHashMap();
    public static final TupleFactory<Pair> PAIR = new TupleFactory<Pair>(){

        @Override
        public Pair makeTuple(Object ... values) {
            return Pair.of(values[0], values[1]);
        }
    };
    public static final TupleFactory<Tuple3> TUPLE3 = new TupleFactory<Tuple3>(){

        @Override
        public Tuple3 makeTuple(Object ... values) {
            return Tuple3.of(values[0], values[1], values[2]);
        }
    };
    public static final TupleFactory<Tuple4> TUPLE4 = new TupleFactory<Tuple4>(){

        @Override
        public Tuple4 makeTuple(Object ... values) {
            return Tuple4.of(values[0], values[1], values[2], values[3]);
        }
    };
    public static final TupleFactory<TupleN> TUPLEN = new TupleFactory<TupleN>(){

        @Override
        public TupleN makeTuple(Object ... values) {
            return new TupleN(values);
        }
    };

    public void initialize() {
    }

    public abstract T makeTuple(Object ... var1);

    public static <T extends Tuple> TupleFactory<T> getTupleFactory(Class<T> tupleClass) {
        if (tupleClass == Pair.class) {
            return PAIR;
        }
        if (tupleClass == Tuple3.class) {
            return TUPLE3;
        }
        if (tupleClass == Tuple4.class) {
            return TUPLE4;
        }
        if (tupleClass == TupleN.class) {
            return TUPLEN;
        }
        if (customTupleFactories.containsKey(tupleClass)) {
            return customTupleFactories.get(tupleClass);
        }
        throw new IllegalArgumentException("Can't create TupleFactory for " + tupleClass);
    }

    public static <T extends Tuple> TupleFactory<T> create(Class<T> clazz, Class ... typeArgs) {
        if (customTupleFactories.containsKey(clazz)) {
            return customTupleFactories.get(clazz);
        }
        CustomTupleFactory<T> custom = new CustomTupleFactory<T>(clazz, typeArgs);
        customTupleFactories.put(clazz, custom);
        return custom;
    }

    private static class CustomTupleFactory<T extends Tuple>
    extends TupleFactory<T> {
        private final Class<T> clazz;
        private final Class[] typeArgs;
        private transient Constructor<T> constructor;

        public CustomTupleFactory(Class<T> clazz, Class[] typeArgs) {
            this.clazz = clazz;
            this.typeArgs = typeArgs;
        }

        @Override
        public void initialize() {
            try {
                this.constructor = this.clazz.getConstructor(this.typeArgs);
            }
            catch (Exception e) {
                throw new CrunchRuntimeException(e);
            }
        }

        @Override
        public T makeTuple(Object ... values) {
            try {
                return (T)((Tuple)this.constructor.newInstance(values));
            }
            catch (Exception e) {
                throw new CrunchRuntimeException(e);
            }
        }
    }
}

