/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.base.Splitter;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.MapFn;
import org.apache.hadoop.util.ReflectionUtils;

public class Protos {
    public static <M extends Message> M getDefaultInstance(Class<M> clazz) {
        if (clazz.getConstructors().length > 0) {
            return (M)((Message)ReflectionUtils.newInstance(clazz, null));
        }
        try {
            Message.Builder mb = (Message.Builder)clazz.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            return (M)mb.getDefaultInstanceForType();
        }
        catch (Exception e) {
            throw new CrunchRuntimeException(e);
        }
    }

    public static <M extends Message, K> MapFn<M, K> extractKey(String fieldName) {
        return new ExtractKeyFn(fieldName);
    }

    public static <M extends Message> DoFn<String, M> lineParser(String sep, Class<M> msgClass) {
        return new TextToProtoFn<M>(sep, msgClass);
    }

    private static class TextToProtoFn<M extends Message>
    extends DoFn<String, M> {
        private final String sep;
        private final Class<M> msgClass;
        private transient M msgInstance;
        private transient List<Descriptors.FieldDescriptor> fields;
        private transient Splitter splitter;

        public TextToProtoFn(String sep, Class<M> msgClass) {
            this.sep = sep;
            this.msgClass = msgClass;
        }

        @Override
        public void initialize() {
            this.msgInstance = Protos.getDefaultInstance(this.msgClass);
            this.fields = this.msgInstance.getDescriptorForType().getFields();
            this.splitter = Splitter.on((String)this.sep);
        }

        @Override
        public void process(String input, Emitter<M> emitter) {
            if (input != null && !input.isEmpty()) {
                Message.Builder b = this.msgInstance.newBuilderForType();
                Iterator iter = this.splitter.split((CharSequence)input).iterator();
                boolean parseError = false;
                for (Descriptors.FieldDescriptor fd : this.fields) {
                    String value;
                    if (!iter.hasNext() || (value = (String)iter.next()) == null || value.isEmpty()) continue;
                    Object parsedValue = null;
                    try {
                        switch (fd.getJavaType()) {
                            case STRING: {
                                parsedValue = value;
                                break;
                            }
                            case INT: {
                                parsedValue = Integer.valueOf(value);
                                break;
                            }
                            case LONG: {
                                parsedValue = Long.valueOf(value);
                                break;
                            }
                            case FLOAT: {
                                parsedValue = Float.valueOf(value);
                                break;
                            }
                            case DOUBLE: {
                                parsedValue = Double.valueOf(value);
                                break;
                            }
                            case BOOLEAN: {
                                parsedValue = Boolean.valueOf(value);
                                break;
                            }
                            case ENUM: {
                                parsedValue = fd.getEnumType().findValueByName(value);
                            }
                        }
                        b.setField(fd, parsedValue);
                    }
                    catch (NumberFormatException nfe) {
                        this.increment(ParseErrors.NUMBER_FORMAT);
                        parseError = true;
                        break;
                    }
                }
                if (parseError) {
                    this.increment(ParseErrors.TOTAL);
                } else {
                    emitter.emit(b.build());
                }
            }
        }

        static enum ParseErrors {
            TOTAL,
            NUMBER_FORMAT;

        }
    }

    private static class ExtractKeyFn<M extends Message, K>
    extends MapFn<M, K> {
        private final String fieldName;
        private transient Descriptors.FieldDescriptor fd;

        public ExtractKeyFn(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public K map(M input) {
            if (input == null) {
                throw new IllegalArgumentException("Null inputs not supported by Protos.ExtractKeyFn");
            }
            if (this.fd == null) {
                this.fd = input.getDescriptorForType().findFieldByName(this.fieldName);
                if (this.fd == null) {
                    throw new IllegalStateException("Could not find field: " + this.fieldName + " in message: " + input);
                }
            }
            return (K)input.getField(this.fd);
        }
    }
}

