/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.MapFn;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.Protos;
import org.apache.crunch.util.SerializableSupplier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class PTypes {
    public static final MapFn<ByteBuffer, BigInteger> BYTE_TO_BIGINT = new MapFn<ByteBuffer, BigInteger>(){

        @Override
        public BigInteger map(ByteBuffer input) {
            return input == null ? null : new BigInteger(input.array());
        }
    };
    public static final MapFn<BigInteger, ByteBuffer> BIGINT_TO_BYTE = new MapFn<BigInteger, ByteBuffer>(){

        @Override
        public ByteBuffer map(BigInteger input) {
            return input == null ? null : ByteBuffer.wrap(input.toByteArray());
        }
    };
    private static final MapFn<ByteBuffer, UUID> BYTE_TO_UUID = new MapFn<ByteBuffer, UUID>(){

        @Override
        public UUID map(ByteBuffer input) {
            return new UUID(input.getLong(), input.getLong());
        }
    };
    private static final MapFn<UUID, ByteBuffer> UUID_TO_BYTE = new MapFn<UUID, ByteBuffer>(){

        @Override
        public ByteBuffer map(UUID input) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.asLongBuffer().put(input.getMostSignificantBits()).put(input.getLeastSignificantBits());
            return bb;
        }
    };

    public static PType<BigInteger> bigInt(PTypeFamily typeFamily) {
        return typeFamily.derivedImmutable(BigInteger.class, BYTE_TO_BIGINT, BIGINT_TO_BYTE, typeFamily.bytes());
    }

    public static PType<UUID> uuid(PTypeFamily ptf) {
        return ptf.derivedImmutable(UUID.class, BYTE_TO_UUID, UUID_TO_BYTE, ptf.bytes());
    }

    public static <T> PType<T> jsonString(Class<T> clazz, PTypeFamily typeFamily) {
        return typeFamily.derived(clazz, new JacksonInputMapFn<T>(clazz), new JacksonOutputMapFn(), typeFamily.strings());
    }

    public static <T extends Message> PType<T> protos(Class<T> clazz, PTypeFamily typeFamily) {
        return typeFamily.derivedImmutable(clazz, new ProtoInputMapFn<T>(clazz), new ProtoOutputMapFn(), typeFamily.bytes());
    }

    public static <T extends Message> PType<T> protos(Class<T> clazz, PTypeFamily typeFamily, SerializableSupplier<ExtensionRegistry> supplier) {
        return typeFamily.derivedImmutable(clazz, new ProtoInputMapFn<T>(clazz, supplier), new ProtoOutputMapFn(), typeFamily.bytes());
    }

    public static <T extends TBase> PType<T> thrifts(Class<T> clazz, PTypeFamily typeFamily) {
        return typeFamily.derived(clazz, new ThriftInputMapFn<T>(clazz), new ThriftOutputMapFn(), typeFamily.bytes());
    }

    public static <T extends Enum> PType<T> enums(Class<T> type, PTypeFamily typeFamily) {
        return typeFamily.derivedImmutable(type, new EnumInputMapper<T>(type), new EnumOutputMapper(), typeFamily.strings());
    }

    private static class EnumOutputMapper<T extends Enum>
    extends MapFn<T, String> {
        private EnumOutputMapper() {
        }

        @Override
        public String map(T input) {
            return ((Enum)input).name();
        }
    }

    private static class EnumInputMapper<T extends Enum>
    extends MapFn<String, T> {
        private final Class<T> type;

        EnumInputMapper(Class<T> type) {
            this.type = type;
        }

        @Override
        public T map(String input) {
            return Enum.valueOf(this.type, input);
        }
    }

    private static class ThriftOutputMapFn<T extends TBase>
    extends MapFn<T, ByteBuffer> {
        private transient TSerializer serializer;

        ThriftOutputMapFn() {
        }

        @Override
        public void initialize() {
            this.serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        }

        @Override
        public ByteBuffer map(T t) {
            try {
                return ByteBuffer.wrap(this.serializer.serialize(t));
            }
            catch (TException e) {
                throw new CrunchRuntimeException((Exception)((Object)e));
            }
        }
    }

    private static class ThriftInputMapFn<T extends TBase>
    extends MapFn<ByteBuffer, T> {
        private final Class<T> clazz;
        private transient T instance;
        private transient TDeserializer deserializer;
        private transient byte[] bytes;

        ThriftInputMapFn(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void initialize() {
            this.instance = (TBase)ReflectionUtils.newInstance(this.clazz, null);
            this.deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            this.bytes = new byte[0];
        }

        @Override
        public T map(ByteBuffer bb) {
            TBase next = this.instance.deepCopy();
            int len = bb.limit() - bb.position();
            if (len != this.bytes.length) {
                this.bytes = new byte[len];
            }
            System.arraycopy(bb.array(), bb.position(), this.bytes, 0, len);
            try {
                this.deserializer.deserialize(next, this.bytes);
            }
            catch (TException e) {
                throw new CrunchRuntimeException((Exception)((Object)e));
            }
            return (T)next;
        }
    }

    private static class ProtoOutputMapFn<T extends Message>
    extends MapFn<T, ByteBuffer> {
        ProtoOutputMapFn() {
        }

        @Override
        public ByteBuffer map(T proto) {
            return ByteBuffer.wrap(proto.toByteArray());
        }
    }

    private static class ProtoInputMapFn<T extends Message>
    extends MapFn<ByteBuffer, T> {
        private final Class<T> clazz;
        private final SerializableSupplier<ExtensionRegistry> extensionSupplier;
        private transient T instance;
        private transient ExtensionRegistry registry;

        ProtoInputMapFn(Class<T> clazz) {
            this(clazz, null);
        }

        ProtoInputMapFn(Class<T> clazz, SerializableSupplier<ExtensionRegistry> extensionSupplier) {
            this.clazz = clazz;
            this.extensionSupplier = extensionSupplier;
        }

        @Override
        public void initialize() {
            this.instance = Protos.getDefaultInstance(this.clazz);
            this.registry = this.extensionSupplier != null ? (ExtensionRegistry)this.extensionSupplier.get() : ExtensionRegistry.getEmptyRegistry();
        }

        @Override
        public T map(ByteBuffer bb) {
            try {
                return (T)this.instance.newBuilderForType().mergeFrom(bb.array(), bb.position(), bb.limit(), (ExtensionRegistryLite)this.registry).build();
            }
            catch (InvalidProtocolBufferException e) {
                throw new CrunchRuntimeException((Exception)((Object)e));
            }
        }
    }

    private static class JacksonOutputMapFn<T>
    extends MapFn<T, String> {
        private transient ObjectMapper mapper;

        private JacksonOutputMapFn() {
        }

        @Override
        public void initialize() {
            this.mapper = new ObjectMapper();
        }

        @Override
        public String map(T input) {
            try {
                return this.mapper.writeValueAsString(input);
            }
            catch (Exception e) {
                throw new CrunchRuntimeException(e);
            }
        }
    }

    private static class JacksonInputMapFn<T>
    extends MapFn<String, T> {
        private final Class<T> clazz;
        private transient ObjectMapper mapper;

        JacksonInputMapFn(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void initialize() {
            this.mapper = new ObjectMapper();
        }

        @Override
        public T map(String input) {
            try {
                return (T)this.mapper.readValue(input, this.clazz);
            }
            catch (Exception e) {
                throw new CrunchRuntimeException(e);
            }
        }
    }
}

