/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import java.util.Collection;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;

public class PTypeUtils {
    public static <T> PType<T> convert(PType<T> ptype, PTypeFamily tf) {
        if (ptype instanceof PTableType) {
            PTableType ptt = (PTableType)ptype;
            return tf.tableOf(tf.as(ptt.getKeyType()), tf.as(ptt.getValueType()));
        }
        Class<T> typeClass = ptype.getTypeClass();
        if (Tuple.class.isAssignableFrom(typeClass)) {
            List<PType> subTypes = ptype.getSubTypes();
            if (Pair.class.equals(typeClass)) {
                return tf.pairs(tf.as(subTypes.get(0)), tf.as(subTypes.get(1)));
            }
            if (Tuple3.class.equals(typeClass)) {
                return tf.triples(tf.as(subTypes.get(0)), tf.as(subTypes.get(1)), tf.as(subTypes.get(2)));
            }
            if (Tuple4.class.equals(typeClass)) {
                return tf.quads(tf.as(subTypes.get(0)), tf.as(subTypes.get(1)), tf.as(subTypes.get(2)), tf.as(subTypes.get(3)));
            }
            if (TupleN.class.equals(typeClass)) {
                PType[] newPTypes = subTypes.toArray(new PType[subTypes.size()]);
                for (int i = 0; i < newPTypes.length; ++i) {
                    newPTypes[i] = tf.as(subTypes.get(i));
                }
                return tf.tuples(newPTypes);
            }
        }
        if (Collection.class.isAssignableFrom(typeClass)) {
            return tf.collections(tf.as(ptype.getSubTypes().get(0)));
        }
        return tf.records(typeClass);
    }

    private PTypeUtils() {
    }
}

